#include "cv.h"
#include "_homogen.h"

using namespace cv;

Mat R (const unsigned int axis, const double angle)
{
	assert((axis == RX)||(axis == RY)||(axis == RZ));
	Mat m(4,4,CV_64FC1);
	m = Scalar::all(0);
	m.at<double>(3,3) = 1;
	double c = cos(angle);
	double s = sin(angle);
	if (axis == RX)
	{
		m.at<double>(0,0) = 1;
		m.at<double>(1,1) = m.at<double>(2,2) = c;
		m.at<double>(1,2) = -s;
		m.at<double>(2,1) = s;
	}
	else if (axis == RY)
	{
		m.at<double>(1,1) = 1;
		m.at<double>(0,0) = m.at<double>(2,2) = c;
		m.at<double>(0,2) = s;
		m.at<double>(2,0) = -s;		
	}
	else if (axis == RZ)
	{
		m.at<double>(2,2) = 1;
		m.at<double>(0,0) = m.at<double>(1,1) = c;
		m.at<double>(0,1) = -s;
		m.at<double>(1,0) = s;	
	}
	return(m);
}

Mat T (const double x, const double y, const double z)
{
	Mat m(4,4,CV_64FC1);
	m = Scalar::all(0);
	m.at<double>(0,3) = x;	
	m.at<double>(1,3) = y;	
	m.at<double>(2,3) = z;
	m.at<double>(0,0) = m.at<double>(1,1) = m.at<double>(2,2) = m.at<double>(3,3) = 1;
	return m;
}

Mat hnorm(const Mat & m)
{
	assert((m.cols == 4) && (m.rows == 4));
	assert(m.at<double>(3,3) != 0);
	Mat n(3,1,CV_64FC1);
	n.at<double>(0,0) = m.at<double>(0,3) / m.at<double>(3,3);
	n.at<double>(0,1) = m.at<double>(1,3) / m.at<double>(3,3);
	n.at<double>(0,2) = m.at<double>(2,3) / m.at<double>(3,3);
	return n;
}