
//neuer Pfad
//		../../../Daten/kalibrierung2/kalibrierung2.txt
//alter Pfad 
//		../../../Daten/geometry-aussen-2-B/liste-aussen-2-B.txt


#define MIN4(a,b,c,d)  ((MIN((a),(b))) < (MIN((c),(d))) ? MIN((a),(b)) : MIN((c),(d)))
#define MAX4(a,b,c,d)  ((MAX((a),(b))) > (MAX((c),(d))) ? MAX((a),(b)) : MAX((c),(d)))

#include <stdlib.h>
#include <vector>
#include <string>
#include <stdio.h>
#include <iostream>

#include "cv.h"
#include "highgui.h"

#include "_homogen.h"


using namespace std;
using namespace cv;

void printFloatMat(CvMat* m)	//TODO generalisieren für datentypen
{
	double * p = m->data.db;
	for(int i = m->height; i > 0; i--)
	{
		for(int j = m->width; j > 0; j--)
		{
			printf("%f ", *p++);
		}
		printf("\n");
	}
}

void printFloatMat(const Mat& m)	//TODO generalisieren für datentypen
{
	for(int i = 0; i < m.size().height; i++)
	{
		double * p = (double*) m.ptr(i);
		for(int j = 0; j < m.size().width; j++)
		{
			for(int k = 0; k < m.channels(); k++)
			{
				printf("%f ", p[j * m.channels() + k]);		//TODO iteratoren
			}
		}
		printf("\n");
	}
}


double betrag(CvMat* m)
{
	//TODO dim > 3?
	CV_Assert(m->width == 1 || m->height == 1);	//TODO double oder long?
	double sum = 0;	//TODO reicht das?
	for (int i = (m->width * m->height) - 1; i >= 0; i--)
	{
		sum += (m->data.db[i] *  m->data.db[i]);	
	}
		
	return cvSqrt(sum);
}


void project (double x, double y, double cx, double cy, double fx, double fy, double distance, const CvMat * norm, CvMat* dest)
{
			//TODO!! KLARA!
				double termx = (x - cx) / fx;
				double termy = (y - cy) / fy;
				double lambda = distance / (termx * norm->data.db[0] + termy * norm->data.db[1] + norm->data.db[2]);
				CV_MAT_ELEM(*dest, double, 0, 0) = lambda * termx;
				CV_MAT_ELEM(*dest, double, 0, 1) = lambda * termy;
				CV_MAT_ELEM(*dest, double, 0, 2) = lambda;
}

void pixel2LUT(const CvMat * undistPts, CvMat* LUT, double cx, double cy, double fx, double fy, double Ld, CvMat * Ln)
{
	CvMat * punkt = cvCreateMat(1,3,CV_64FC1);
	
	double * anotherPtr = undistPts->data.db;
	
	for (int w = 0; w < LUT->rows; w++ )
	{
		for (int h = 0; h < LUT->cols; h++)	//höhe läuft schneller
		{
			double uw = *(anotherPtr++);
			double uh = *(anotherPtr++);
			
			project(uw, uh, cx, cy, fx, fy, Ld, Ln, punkt);
						
			double * LUTptr = (double *) (LUT->data.ptr + w * LUT->step);  //in byte
			LUTptr += h * 3;  /*channels*/								//in double
			/* X , Y, Z */
			
			double X =CV_MAT_ELEM(*punkt, double, 0, 1);		//lateral
			double Y = CV_MAT_ELEM(*punkt, double, 0, 0);		//höhe!  TODO
			double Z = CV_MAT_ELEM(*punkt, double, 0, 2);		//entfernung
			if (Z > 0)
				{
					
					
				Z = - Z;
				Y = - Y;
				X = - X;
				
				/*
				float X_ = X;
				float Y_ = Y;
				float Z_ = Z;

				float gier = 5 * (CV_PI / 180)	;
				X = -cos(gier) * X_ + sin(gier) * Z_;
				Z = sin(gier) * X_ + cos(gier) * Z_;

				float nick =  -15 * (CV_PI / 180);		
				Y = -cos(nick) * Y_ + sin(nick) * Z_;
				Z = sin(nick) * Y_ + cos(nick) * Z_;
 				
				Y -= 8.7 / 3.6;  //höhe
				X -= -3.5 / 3.6; //seitlich
				//Z -= - 5.5 / 3.6; //entfernung
			*/



				double sc = 1.0 / 3.50;	//skalierfaktor cm/Weltkoordinaten
				double cell = 0.0005; //CMOS-Punktabstand in cm;
				double BM = CV_PI / 180;				

				
				Mat P = T(X,Y,Z);
				
		

				
			//Projektionszentrum -> Hauptpunkt
					double tfz =  - (fx + fy) / 2 * cell * sc; //diese kleine Ungenauigkeit (Mittel fx, fy) ist vertretbar
					P = T(0,0,tfz) * P;		

						//5 ° Drehung Kamerahalter			
							double rty = - 5.0 * BM;	
							P = R(RY, rty) * P;			

				//Kameraplatine -> Kamerahalter
							double tcx = 1.17 * sc;
							double tcy = +1.60 * sc;
							P =  T(tcx, tcy, 0) * P;
			
									
						//15° Neigung K-Halter
							double rhx = -15.0 * BM;
							P = R(RX, rhx) * P;
												
						//Punkt a/b auf Kamerahalter
							double thx = 0.42 * sc;
							double thy = + 0.4 * sc;
							double thz = - 0.82 * sc;		
							 P = T(thx,thy,thz) * P;
														
				//Kamerahalter -> Motorachsenfußpunkt
					double trx = -5.475 * sc;
					double tr_y = +7.31 * sc;
					double trz = 0.77 * sc;				
					P = T(trx, tr_y, trz) * P;				
										
				Mat Q = hnorm(P);
				X = 0 - Q.at<double>(0,0);
				Y = 0 - Q.at<double>(0,1); // ATTN
				Z = Q.at<double>(0,2);



			
			} else 
			{
				X = Y = Z = 0;
			}
			
			*LUTptr = X;	//012, 021
			LUTptr++;
			*LUTptr = Y;
			LUTptr++;
			*LUTptr = Z;
		
		}
	}
}

void normalize(CvMat* m)
{
	cvConvertScale(m,m,1/betrag(m));
}

// distanz punkt-Ebene
double dpe(CvMat* p, CvMat* n, double d)
{	
	double r = cvDotProduct(p, n) - d;
	//if (r < 0) r *= -1;
	
	double b = 1 / betrag(n);
	//if (b < 0) b *= -1;
	return r * b;
}

void readFilenames(std::vector <std::string> & imageFileNames, char* listFileName)
{
    FILE* f = fopen(listFileName, "rt");
    if( !f )
    {
        fprintf(stderr, "can not open file %s for reading image list\n", listFileName );
    }

    char buf[1024];
    while ( fgets( buf, sizeof(buf)-3, f ))
    {
        size_t len = strlen(buf);
        while( len > 0 && isspace(buf[len-1]))
            buf[--len] = '\0';
        
		if( buf[0] == '#') continue;

        imageFileNames.push_back(buf);
    }
    fclose(f);
}

class imagePair
{
		
private:
	//int _imagesExternallyCreated; //TODO trash
	std::string _noLaserImageName;
	std::string _laserImageName;
	
	IplImage * _noLaserImage;
	IplImage * _laserImage;
	IplImage * undistNoLaserImage;
	IplImage* diffImage;
	IplImage* undistDiffImage;
	IplImage* undistSparseDiffImage;
	IplImage* undistFullDiffImage;
	IplImage* undistGreyFullDiffImage;
	IplImage* undistGreySparseDiffImage;
	IplImage* undistHoughGreySparseDiffImage;
	
	CvMat * punkt1;
	CvMat * punkt2;
	CvMat * vektor12;
	CvPoint2D32f il1;
	CvPoint2D32f il2;
	CvMat * translation;

public:

	void initMats(void)
	{
			undistNoLaserImage = cvCloneImage(_noLaserImage);
			diffImage = cvCloneImage(_laserImage);	
			undistDiffImage = cvCloneImage(_laserImage);
			undistSparseDiffImage = cvCloneImage(_laserImage);
			undistFullDiffImage = cvCloneImage(_laserImage);
			undistGreySparseDiffImage = cvCreateImage (cvSize(_laserImage->width, _laserImage->height), _laserImage->depth, 1);
            undistGreyFullDiffImage = cvCloneImage(undistGreySparseDiffImage);
			undistHoughGreySparseDiffImage = cvCloneImage(undistGreySparseDiffImage);
			
			translation = cvCreateMat(3,1, CV_64FC1);
			punkt1 =  cvCreateMat(1,3, CV_64FC1);
			punkt2 =  cvCreateMat(1,3, CV_64FC1);
			vektor12 =  cvCreateMat(1,3, CV_64FC1);
	}

	imagePair(const std::string sl, const std::string sn) : 
		_noLaserImageName(sl), _laserImageName(sn)
	{
		_noLaserImage = cvLoadImage(_noLaserImageName.c_str(), CV_LOAD_IMAGE_COLOR);			
		_laserImage = cvLoadImage(_laserImageName.c_str(), CV_LOAD_IMAGE_COLOR); 
		if(_noLaserImage == 0)
		{
			std::cerr << "could not open " << _noLaserImageName << std::endl;
		}
		if(_laserImage == 0)
		{
			std::cerr << "could not open " << _laserImageName << std::endl;
		}
		initMats();
	}
	
	imagePair(CvCapture * capture)
	{
		_laserImage = 0;
		_noLaserImage = 0;
		while (! _laserImage)
		{	
			_laserImage = cvQueryFrame(capture);
		}
		int i = cvWaitKey(10);	//TODO
		while(! _noLaserImage)
		{
			_noLaserImage = cvQueryFrame(capture);
		}
		initMats();
		cvNamedWindow("foo", 1);
		cvNamedWindow("bar", 1);
		cvShowImage("foo", _laserImage);
		cvShowImage("bar", _noLaserImage);
		cvWaitKey(50);
	}
	
	bool findBoard(const int patternWidth, const int patternHeight, const double squareSize, CvMat* intrinsicMatrix, CvMat* distortionCoefficients, double cx, double cy, double fx, double fy /*TODO redundant zu intrinsic matrix*/)
	{
			cvNamedWindow( "nolaser", 1 );
			cvShowImage("nolaser", _noLaserImage);
			cvWaitKey(50);
				cvNamedWindow( "laser", 1 );
			cvShowImage("laser", _laserImage);	
			cvWaitKey(500);
		
		CvSize s = {patternWidth, patternHeight};

		// find board
			//cvUndistort2(_noLaserImage, undistNoLaserImage, intrinsicMatrix, distortionCoefficients);

			CvPoint2D32f* corners = new(CvPoint2D32f [patternWidth * patternHeight]);
			
			int cornerCount; 
			int boardFound = cvFindChessboardCorners(_noLaserImage, s, corners,
				& cornerCount, CV_CALIB_CB_ADAPTIVE_THRESH | CV_CALIB_CB_FILTER_QUADS); //Wird auf dem unentzerrten Bild ausgeführt, weil
				//findExtrinsicCameraParams2 bereits entzerrt!
				
			if(!boardFound) 
			{
				fprintf(stderr, "no full board found in image\n");
				return false;
			}
			if (cornerCount != patternWidth * patternHeight)
			{
				fprintf(stderr, "partial board found, reject\n");
				return false;
			}
			
			IplImage * grayImage = cvCreateImage(cvGetSize(_noLaserImage), 8, 1);//TODO-bei Houghlinei auch
			cvCvtColor(_noLaserImage, grayImage, CV_BGR2GRAY);
			
			cvFindCornerSubPix(grayImage, corners, cornerCount, 
				cvSize(5,5), /*TODO: suchfenster parametrisiseren*/
				cvSize(-1,-1), 
				cvTermCriteria(CV_TERMCRIT_EPS+CV_TERMCRIT_ITER,30,0.1)); //TODO
			cvReleaseImage(&grayImage);
		

			
		// put the data into the matrices

			CvMat* _chessboardWorldData = cvCreateMat( patternWidth * patternHeight, 2, CV_64FC1 );
			CvMat* _chessboardModelData = cvCreateMat( patternWidth * patternHeight, 3, CV_64FC1 ); //3D
			CvMat* _chessboardModelData2D = cvCreateMat( patternWidth * patternHeight, 2, CV_64FC1 ); //2D
			
			for (int i = 0; i < patternWidth * patternHeight; i++)
			{
				
				cvSetReal2D(_chessboardWorldData, i, 0, corners[i].x);
				cvSetReal2D(_chessboardWorldData, i, 1, corners[i].y);
				
				cvSetReal2D(_chessboardModelData, i, 0,  (i / patternWidth) * squareSize);
				cvSetReal2D(_chessboardModelData, i, 1,  (i % patternWidth) * squareSize);
				cvSetReal2D(_chessboardModelData, i, 2,  0);


				//ATTN!
				// Linienfinder und der Schachbrettfinder verwenden verschiedene Matrizen?
				
				cvSetReal2D(_chessboardModelData2D, i, 1,  (i / patternWidth) * squareSize);
				cvSetReal2D(_chessboardModelData2D, i, 0,  (i % patternWidth) * squareSize);
				
			}
			
		//corner indexes
			//int c0 = 0;
			int cW = patternWidth - 1;
			int cH = (patternWidth * (patternHeight - 1));
			int cWH = cH + cW;
		
		// get chessboard orientation
		
		    CvMat * rotationRod = cvCreateMat(3,1, CV_64FC1);
			
			cvFindExtrinsicCameraParams2(_chessboardModelData, _chessboardWorldData, 
					intrinsicMatrix, distortionCoefficients, rotationRod, translation);
					
			CvMat * rotation = cvCreateMat(3, 3, CV_64FC1);
			cvRodrigues2(rotationRod, rotation);
			
			std::cout << "rotation" << std::endl;
			std::cout << std::endl;
	
		// laser ROI
		
			CvRect laserROI = cvRect( 
				MIN4(corners[0].x, corners[cW].x, corners[cH].x, corners[cWH].x),
				MIN4(corners[0].y, corners[cW].y, corners[cH].y, corners[cWH].y),
				MAX4(corners[0].x, corners[cW].x, corners[cH].x, corners[cWH].x)
					- MIN4(corners[0].x, corners[cW].x, corners[cH].x, corners[cWH].x),
				MAX4(corners[0].y, corners[cW].y, corners[cH].y, corners[cWH].y)
					- MIN4(corners[0].y, corners[cW].y, corners[cH].y, corners[cWH].y));
			
			int rejectROI = 20;
			int minx = std::min(laserROI.x, laserROI.x + laserROI.width);
			int maxx = std::max(laserROI.x, laserROI.x + laserROI.width);
			int miny = std::min(laserROI.y, laserROI.y + laserROI.height);
			int maxy = std::max(laserROI.y, laserROI.y + laserROI.height);
			if ((minx < rejectROI) || (maxx > _laserImage->width - 1 - rejectROI)
				||(miny < rejectROI) || (maxy > _laserImage->height- 1 - rejectROI))
			{ 
				std::cerr << "invalid laserROI, reject board" << std:: endl;
				return false;
			}
		
		// find laserline within ROI
			
			CvMemStorage * storage = cvCreateMemStorage(0); //TODO? stl::vector?
			CvSeq * houghline = 0;
			
			cvAbsDiff(_laserImage, _noLaserImage, diffImage);

			cvUndistort2(diffImage, undistDiffImage, intrinsicMatrix, distortionCoefficients);
			
			
			cvThreshold(undistDiffImage, undistSparseDiffImage, 127, 255, CV_THRESH_BINARY); //TODO fix. Wert!
			//Diese Schraube ist sehr wichtig für eine gute Laserlinie n. Hough !!!! 100 -> nur Pixel heller 100 für houghlinie

			cvThreshold(undistDiffImage, undistFullDiffImage, 20, 255, CV_THRESH_BINARY); //TODO fix. Wert!
			//Schraube für die Scanfunktion
			
			cvCvtColor(undistSparseDiffImage, undistGreySparseDiffImage, CV_RGB2GRAY);
			cvCvtColor(undistFullDiffImage, undistGreyFullDiffImage, CV_RGB2GRAY);
			
			undistHoughGreySparseDiffImage = cvCloneImage(undistGreySparseDiffImage); //falls im Scanner nochmal verwendet
																				// ?schriebt hough?
			
			cvSetImageROI(undistHoughGreySparseDiffImage, laserROI);  //!
			
			
			//CvMat * houghline = cvCreateMat(1,1, CV_64FC2); //TODO - 1,1 matrices suck
			houghline = cvHoughLines2(undistHoughGreySparseDiffImage, storage, 
				CV_HOUGH_STANDARD, 1, CV_PI / 18000, 10/*THRESHOLD*/); // TODO fix. Thr. 100 // Winkelauflösung 0.01 Grad
				
			if (houghline->total < 1)
			{
				std::cerr << "no hough line found " << std::endl;
				return false;
			}
			
			// draw hough line
				float * h = (float*) cvGetSeqElem(houghline, 0);
				float rho = h[0];
				float theta = h[1];
				double a = cos((double)theta), b = sin((double)theta);
				double x0 = a * rho, y0 = b * rho;
				double pt1x, pt1y, pt2x, pt2y;
				pt1x = x0 + 1000*(-b);		//TODO !
				pt1y = y0 + 1000*(a);
				pt2x = x0 - 1000*(-b);
				pt2y = y0 - 1000*(a);

				//hough-xy ist relativ zur ROI. Achtung:
					//	rectangle hat x,y,h,w; es ist nicht garantiert dass h, w > 0! also
					pt1x += std::min(laserROI.x, laserROI.x + laserROI.width);
					pt1y += std::min(laserROI.y, laserROI.y + laserROI.height);
					pt2x += std::min(laserROI.x, laserROI.x + laserROI.width);
					pt2y += std::min(laserROI.y, laserROI.y + laserROI.height);
				
				std::cout << std::endl << "rho: " << rho << " theta: " << theta << std::endl << std::endl;
		
				
		//////////////////////
		// punktbestimmung
				
				CvMat * chNorm = cvCreateMat(3,1,CV_64FC1);
				CV_MAT_ELEM(*chNorm, double, 0, 0) = CV_MAT_ELEM(*rotation, double, 0, 2);
				CV_MAT_ELEM(*chNorm, double, 1, 0) = CV_MAT_ELEM(*rotation, double, 1, 2);
				CV_MAT_ELEM(*chNorm, double, 2, 0) = CV_MAT_ELEM(*rotation, double, 2, 2);

				CvMat * negTran = cvCreateMat(3,1,CV_64FC1);
				CV_MAT_ELEM(*negTran, double, 0, 0) = 0 - CV_MAT_ELEM(*translation, double, 0, 0);
				CV_MAT_ELEM(*negTran, double, 1, 0) = 0 - CV_MAT_ELEM(*translation, double, 1, 0);
				CV_MAT_ELEM(*negTran, double, 2, 0) = 0 - CV_MAT_ELEM(*translation, double, 2, 0);
							
				double chDist = dpe(negTran, chNorm, 0);
				
				project(pt1x, pt1y, cx, cy, fx, fy, chDist, chNorm, punkt1);
				project(pt2x, pt2y, cx, cy, fx, fy, chDist, chNorm, punkt2);

				std::cout << "punkt1" << std::endl;
				printFloatMat(punkt1);std::cout<<std::endl<<std::endl;
				
				std::cout << "punkt2" << std::endl;
				printFloatMat(punkt2);std::cout<<std::endl<<std::endl;
				
				cvSub(punkt2, punkt1, vektor12); 


		// display
    
			printf("%s \n" , _laserImageName.c_str());			

			IplImage* undistShowImage = cvCloneImage(_laserImage);
			cvUndistort2(_laserImage, undistShowImage, intrinsicMatrix, distortionCoefficients);
			
			cvDrawChessboardCorners( undistShowImage, s, corners , cornerCount, boardFound );
			
			cvLine(undistShowImage, cvPoint(pt1x, pt1y), cvPoint(pt2x, pt2y), CV_RGB(255,0,0));	
			
		
			cvRectangle(undistShowImage, cvPoint(laserROI.x, laserROI.y), 
				cvPoint(laserROI.x + laserROI.width, laserROI.y + laserROI.height),
				cvScalar(255,255,255,0)
				);
		
			cvNamedWindow( "corners", 1 );
			//cvNamedWindow( "with_distortion", 1);
			cvShowImage("corners", undistShowImage);
			//cvShowImage("with_distortion", _laserImage);
			cvWaitKey(500);
			
			return true;
		
			// TODO - deallcoate 

	}
	
	CvPoint3D32f givePoint()
	{
		CvPoint3D32f p;
		p.x = punkt1->data.db[0];
		p.y = punkt1->data.db[1];
		p.z = punkt1->data.db[2];
		return p;
	}
	
	CvPoint3D32f givePoint2()
	{
		CvPoint3D32f p;
		p.x = punkt2->data.db[0];
		p.y = punkt2->data.db[1];
		p.z = punkt2->data.db[2];
		return p;		
	}

	CvPoint3D32f giveVector()
	{
		CvPoint3D32f p;
		p.x = vektor12->data.db[0];
		p.y = vektor12->data.db[1];
		p.z = vektor12->data.db[2];
		return p;
	}

	CvPoint2D32f givePixel()
	{
		return il1;		
	}
	
	CvPoint2D32f givePixel2()
	{
		return il2;
	}

	
	void scan(IplImage* Y, IplImage* Z)		//nur zur oberflächlichen Plausibilitätsprüfung, nicht identisch mit Scan in Scanner.cpp
	{
		int radarHeight= 500;
		int radarWidth = 500;
		int radarScale = 10;
		IplImage * radarImage = cvCreateImage(cvSize(radarHeight , radarWidth ), 8, 3);
		cvSetZero(radarImage);
		
		IplImage* clone = cvCloneImage(undistGreyFullDiffImage);
		cvSmooth(clone, undistGreyFullDiffImage, CV_MEDIAN);

		
		for(int w = 0; w < undistGreyFullDiffImage->width-1; w++)
		{
			uchar maxValue = 0;
			int maxValuePos = 0;

			for(int h = 0; h < undistGreyFullDiffImage->height-1; h++)
			{
			
				uchar * u = cvPtr2D( undistGreyFullDiffImage, h, w);
				uchar value = * u;
				
				if (value > maxValue)
				{
					maxValue = value;
					maxValuePos = h;
				}

			}//h
			
			double * Yrow = (double*) ( Y->imageDataOrigin + w * Y->widthStep);
			double * Zrow = (double*) ( Z->imageDataOrigin + w * Z->widthStep);
			Yrow += maxValuePos;
			Zrow += maxValuePos;
			
			double drawY = *Yrow * radarScale;
			double drawZ = *Zrow *radarScale;

			drawY +=  (radarHeight/2); // ATTN
			drawZ +=  (radarWidth/2); 
			
			drawZ =  MAX(0, MIN(radarWidth -1, drawZ));
			drawY =  MAX(0, MIN(radarHeight -1, drawY));
			
			
			//printf("w, mvp: %9d, %9d;  resZ,Y: %9f, %9f;  drawZ,Y: %f, %f\n", w, maxValuePos, resZ, resY, drawZ, drawY);
			
			if ((maxValuePos > 4)&&(maxValuePos < undistGreyFullDiffImage->height - 5))
				cvCircle( radarImage, cvPoint(drawZ, radarHeight - drawY), 1, CV_RGB(255,255,255));
				
			cvCircle(radarImage, cvPoint(radarHeight/2, radarWidth/2), 1, CV_RGB(255,0,0));

		}//w
		cvNamedWindow("schnitt", 1);
		//cvNamedWindow( "FullDiff", 1 );
		//cvNamedWindow( "SparseDiff", 1 );
		cvShowImage("schnitt", radarImage);
		//cvShowImage("FullDiff", undistGreyFullDiffImage);
		//cvShowImage("SparseDiff", undistGreySparseDiffImage);
		cvWaitKey(500);
		//cvDestroyWindow("schnitt");
		//cvDestroyWindow("diff");
	}
		
	~imagePair()
	{
	}
};

void doPCA( const std::vector <CvPoint3D32f> & allePunkte, std::vector <CvPoint3D32f> & wenigerPunkte, 
				CvMat * Ln, double & Ld)
{
						Mat ebenenpunkte(allePunkte.size(), 3, CV_64FC1);

						for (int i = 0; i < allePunkte.size(); i ++)
						{
							CvPoint3D32f p1 = allePunkte[i];
							
							ebenenpunkte.at<double>(i,0) = (double)p1.x;
							ebenenpunkte.at<double>(i,1) = (double)p1.y;
							ebenenpunkte.at<double>(i,2) = (double)p1.z;						
						}
						
						printFloatMat(ebenenpunkte);
						std::cout << std::endl << std::endl;
						
						//PCA pca(ebenenpunkte, Mat(), CV_PCA_DATA_AS_ROW);
						
						Mat covar;
						Mat mean;
						Mat eigenvalues;
						Mat eigenvectors;
						
						int covarFlags = CV_COVAR_NORMAL | CV_COVAR_SCALE | CV_COVAR_ROWS;
						calcCovarMatrix(ebenenpunkte, covar, mean, covarFlags, CV_64F );
						eigen( covar, eigenvalues, eigenvectors, 0, 2);
						std::cout << "mean:" << std::endl;
						printFloatMat(mean);
						std::cout << "covar:" << std::endl;
						printFloatMat(covar);
						std::cout << std::endl << std::endl << std::endl;			
						
						std::cout << std::endl << std::endl;
						printFloatMat(eigenvalues);
						std::cout << std::endl;
						printFloatMat(eigenvectors);
						


				CV_MAT_ELEM(*Ln, double, 0, 0) = eigenvectors.at<double>(2,0);
				CV_MAT_ELEM(*Ln, double, 0, 1) = eigenvectors.at<double>(2,1);
				CV_MAT_ELEM(*Ln, double, 0, 2) = eigenvectors.at<double>(2,2);


				std::cout << "Ln: " << std::endl;
				printFloatMat(Ln);
				std::cout << std::endl;

				normalize(Ln);

				std::cout << "Ln: " << std::endl;
				printFloatMat(Ln);
				std::cout << std::endl;

				std::cout << "mean: " << mean.at<double>(0,0) << " " << mean.at<double>(0,1) << " " << mean.at<double>(0,2) << std::endl;

				double* lnNorm =  Ln->data.db;
				Ld =  (0 - mean.at<double>(0,0)) * lnNorm[0]
					 + (0 - mean.at<double>(0,1)) * lnNorm[1]
					 + (0 - mean.at<double>(0,2)) * lnNorm[2];

				std::cout << "Ld: " << Ld << std::endl;


					
						double errorsum = 0;
						double error;
						
						CvMat * row = cvCreateMat(1, 3, CV_64FC1);
						for (int t = 0; t < allePunkte.size(); t ++)
						{
							CV_MAT_ELEM(*row, double, 0, 0) = ebenenpunkte.at<double>(t,0);
							CV_MAT_ELEM(*row, double, 0, 1) = ebenenpunkte.at<double>(t,1);
							CV_MAT_ELEM(*row, double, 0, 2) = ebenenpunkte.at<double>(t,2);
							error = dpe(row, Ln, Ld);
							errorsum += error * error;
							std::cout << " " << error;
						}
						std::cout << std::endl << "sqr_err_sum" << errorsum << std::endl;
						
						double averageError = errorsum / (double)allePunkte.size();

						std::cout << "avg_err" << averageError << std::endl;
						
						for (int t = 0; t < allePunkte.size(); t ++)
						{
							CV_MAT_ELEM(*row, double, 0, 0) = ebenenpunkte.at<double>(t,0);
							CV_MAT_ELEM(*row, double, 0, 1) = ebenenpunkte.at<double>(t,1);
							CV_MAT_ELEM(*row, double, 0, 2) = ebenenpunkte.at<double>(t,2);
							error = dpe(row, Ln, Ld);
							error = error * error;
							if (error > averageError)
							{
								std::cout << "Punkt #" << t << "mit Fehler " << error  << 
									" wird bei der nächsten PCA nicht ber." << std::endl;
							}
							else if ( (std::abs(CV_MAT_ELEM(*row, double, 0, 0)) > 500)||
									(std::abs(CV_MAT_ELEM(*row, double, 0, 0)) > 500)||
									(std::abs(CV_MAT_ELEM(*row, double, 0, 0)) > 500) )
							{
									std::cout << "Punkt #" << t << "besteht Plausibilitätsprüfung nicht " << std::endl;
							}
							else
							{
								wenigerPunkte.push_back(allePunkte[t]);
								std::cout << "Punkt #" << t << "mit Fehler " << error  << 
									" OK" << std::endl;
							}
						}
						

}

int main(int argc, char** argv) {

		double cx = 328.482;
		double cy = 286.517;				
		double fx = 1017.96;
		double fy = 1018.5;
			
		double intrinsics640[] = {
			fx, 0., cx,
			0., fy ,cy,
			0., 0., 1.
		};
		
		double intrinsics320[] = {
			fx / 2, 0., cx / 2 ,
			0., fy / 2, cy / 2 ,
			0., 0., 1.
		};

		CvMat * intrinsicMatrix640 = cvCreateMat(3,3,CV_64FC1);
		cvInitMatHeader(intrinsicMatrix640, 3, 3, CV_64FC1, intrinsics640);
		
		CvMat * intrinsicMatrix320 = cvCreateMat(3,3,CV_64FC1);
		cvInitMatHeader(intrinsicMatrix320, 3, 3, CV_64FC1, intrinsics320);		

		double FOOBAR[] = {-0.270693, 0.0889081, 0.00157935, -0.000280054};
		CvMat * distortionCoefficients = cvCreateMat(4,1,CV_64FC1);
		cvInitMatHeader(distortionCoefficients, 4, 1, CV_64FC1, FOOBAR);
		

	std::vector<imagePair *> imagePairs; 
	
	if (argc > 2)
	{
		fprintf(stderr, "program takes max. one parameter: a file containing a list of images\n");
		return(EXIT_FAILURE);
	}
	 
	if (argc == 2) // read Image list
	{
		std::vector<std::string> imageNameList;
		readFilenames(imageNameList, argv[1]);
		
		//std::vector<imagePair *> imagePairs (imageNameList.size() / 2); //TODO
		for(size_t i = 0; i < imageNameList.size(); i += 2)
		{
			
			
				imagePair * P = new imagePair(imageNameList[i], imageNameList[i+1]);
				if (P->findBoard(8, 6, 1.0, intrinsicMatrix640, distortionCoefficients, cx, cy, fx, fy))
					imagePairs.push_back(P);

		}
	} //argc 2
	
	if (argc == 1)  // CAMERA CAPTURE
	{
		CvCapture* capture = 0;
		capture = cvCreateCameraCapture(-1); // TODO - catch?
		if( !capture )
			return fprintf( stderr, "Could not initialize video capture\n" ), -2;
		
		while (true) //ESC
		{
			imagePair * P = new imagePair(capture);
			printf("searching\n");
			if (P->findBoard(8, 6, 1.0, intrinsicMatrix640, distortionCoefficients, cx, cy, fx, fy))
				imagePairs.push_back(P);
			if (cvWaitKey(10) == 27) exit(1);
		}
		
		if(capture)
			cvReleaseCapture(&capture);
	}

	
	CvMat * Ln = cvCreateMat(1,3,CV_64FC1);
	double Ld;
	
	std::vector<imagePair *> betterImagePairs; 
	
	//Beim jedem Durchgang werden diePunkte mit überdurschschnittlichem Fehler entfernt.
	//Der nächste Durchgang erfolgt nur noch auf den so dezimierten Punkten
	vector <CvPoint3D32f> punktevektor0;
	vector <CvPoint3D32f> punktevektor1;
	vector <CvPoint3D32f> punktevektor2;
	vector <CvPoint3D32f> punktevektor3;
	for (int i = 0; i < imagePairs.size(); i ++)
	{
		CvPoint3D32f p1 = imagePairs[i]->givePoint();
		CvPoint3D32f p2 = imagePairs[i]->givePoint2();
		punktevektor0.push_back(p1);
		punktevektor0.push_back(p2);
	}
						
	std::cerr << std::endl << "***** erster PCA-Durchgang " << std::endl;
	doPCA(punktevektor0, punktevektor1, Ln /*wird verworfen*/, Ld /*wird verworfen*/);
	std::cerr << std::endl << "***** zweiter PCA-Durchgang " << std::endl;
	doPCA(punktevektor1, punktevektor2 /*wird verworfen*/, Ln, Ld);
	std::cerr << std::endl << "***** dritter PCA-Durchgang " << std::endl;
	doPCA(punktevektor2, punktevektor3 /*wird verworfen*/, Ln, Ld);


						
	// Anwendung d. Transformation
		//TODO
		int imageWidth = 640;
		int imageHeight = 480;
		
		CvMat * LUT640 = cvCreateMat(imageWidth, imageHeight, CV_64FC3);
		CvMat * LUT320 = cvCreateMat(imageWidth / 2, imageHeight / 2, CV_64FC3);
		
		CvMat * origPts640 = cvCreateMat(imageHeight * imageWidth,     1, CV_64FC2);
		CvMat * origPts320 = cvCreateMat(imageHeight * imageWidth / 4, 1, CV_64FC2);
		
		CvMat * undistPts640 = cvCreateMat(imageHeight * imageWidth    , 1, CV_64FC2);
		CvMat * undistPts320 = cvCreateMat(imageHeight * imageWidth / 4, 1, CV_64FC2);
		
		double * origPtr640 = origPts640->data.db;
		double * origPtr320 = origPts320->data.db;
		
		for (int w = 0; w < 640; w++ )
		{
			for (int h = 0; h < 480; h++)	//höhe läuft schneller
			{
				origPtr640[0] = (double) w;
				origPtr640[1] = (double) h;
				origPtr640 += 2;
			}
		}
		
		for (double w = 0; w < 320; w++ )
		{
			for (double h = 0; h < 240; h++)	//höhe läuft schneller
			{
				origPtr320[0] =  w; 
				origPtr320[1] =  h; 
				origPtr320 += 2;
			}
		}
		
	
		cvUndistortPoints(origPts640, undistPts640, intrinsicMatrix640, distortionCoefficients, 0, intrinsicMatrix640);
		cvUndistortPoints(origPts320, undistPts320, intrinsicMatrix320, distortionCoefficients, 0, intrinsicMatrix320);
	

			/////////////////////// reverse undistortion (distortion) for LUT320////////////////////////////
			//
			/*
			Mat R;
			Mat A(320,240,CV_32FC1);
			Mat B(320,240,CV_32FC1);
			initUndistortRectifyMap(intrinsicMatrix320, distortionCoefficients, R, intrinsicMatrix320, Size(320,240), CV_32FC1, A, B);
			float * px = (float*) A.data;
			double * undistPtr320 = undistPts320->data.db;
			for (int i = 0; i < 320; i++)
			{
				float * py = (float*) B.data;
				for (int j = 0; j < 240; j++)
				{
					* undistPtr320 = (double) (A.at<float>(j,i));
					undistPtr320++;
					* undistPtr320 = (double) (B.at<float>(j,i));
					undistPtr320++;
				}
			}
			*/

			///////////////////////////////////////////////
			/// bypass undistortion ///////////////
			//	undistPts640 = origPts640;
			//	undistPts320 = origPts320;
			///////////////////////////////////////////////
			
		
		pixel2LUT(undistPts320, LUT320, cx/2, cy/2, fx/2, fy/2, Ld, Ln);	//? TODO !!!!!!! DAS GEHT NICHT? KAMERAPARAMETER SIND F. 640!
		pixel2LUT(undistPts640, LUT640, cx, cy, fx, fy, Ld, Ln);
	
	//display matrices
	

		IplImage * tempX = cvCreateImage(cvSize(LUT640->width, LUT640->height), IPL_DEPTH_64F, 1);
		IplImage * tempY = cvCreateImage(cvSize(LUT640->width, LUT640->height), IPL_DEPTH_64F, 1);
		IplImage * tempZ = cvCreateImage(cvSize(LUT640->width, LUT640->height), IPL_DEPTH_64F, 1);

		cvSplit(LUT640, tempX, tempY, tempZ, 0);
		
		cvConvertScale( tempX, tempX, -100);
		cvConvertScale( tempY, tempY, -0.1);
		cvConvertScale( tempZ, tempZ, -0.01);

		cvNamedWindow("X", 1);
		cvNamedWindow("Y", 1);
		cvNamedWindow("Z", 1);
		cvShowImage("X", tempX);
		cvShowImage("Y", tempY);
		cvShowImage("Z", tempZ);
		cvWaitKey(500);
		cvDestroyWindow("X");
		cvDestroyWindow("Y");
		cvDestroyWindow("Z");

		CvMat * LUT640_32 = cvCreateMat(imageWidth, imageHeight, CV_32FC3);
		CvMat * LUT320_32 = cvCreateMat(imageWidth / 2, imageHeight / 2, CV_32FC3);
		cvConvertScale(LUT640, LUT640_32);
		cvConvertScale(LUT320, LUT320_32);
		cvSave("LUT640.xml", LUT640_32);
		cvSave("LUT320.xml", LUT320_32);
		
		// test matrix with saved files	
			cvSplit(LUT640, tempX, tempY, tempZ, 0); //again
			for (int i = 0; i < imagePairs.size(); i++)
			{
				imagePairs[i]->scan(tempY, tempZ);
			}
	


	cvWaitKey(1);
    return (EXIT_SUCCESS);
}
