#include "RP6RobotBaseLib.h"

int control1 = 1;
int control2 = 2;
int enable12 = 5;
int enable34 = 4;  //fest verlötet, Bez. auf LEDs != IO auf RP6-Platine

signed int motorphase = 0;
signed int rotorPosition;
uint8_t motorphases[8];		//count up -> rotate counterclockwise
int wt = 5; 				//rotor motor step wait time (ms)
int wtRef = 10; 			//different value for reference movement (sonst Aufschwingen)

signed int endschalter = 123;		// TODO - Abgleich mit A110?
signed int rotorStep = 1;			// TODO - default wg. Stromquellenüberlastung, nur ungerade Schritte
signed int maxNominalSweep = 115;	//TODO? abgleich mit A110
signed int maxDangerSweep = 125;

uint8_t rotationspeed = 30;
uint8_t drivespeed = 50;

volatile int rotorStop = 0;
int ignoreRotorStop = 1;


void rotorSet(uint8_t phasebits)
{
	uint8_t write;					//preserve LEDs 3 and 6 (end contact in / laser out)
	write = phasebits & 0b011011;	
	statusLEDs.byte |= write;
	write = phasebits | 0b100100;
	statusLEDs.byte &= write;
	updateStatusLEDs();
	mSleep(wt); 					//TODO ? - blocking!	
}

void stepperOff(void)
{
	rotorSet(0);
	motorphase = 0;
}

void rotorSetRef(uint8_t phasebits)
{
	uint8_t write;	//preserve LEDs 3 and 6 (end contact in / laser out)
	write = phasebits & 0b011011;	
	statusLEDs.byte |= write;
	write = phasebits | 0b100100;
	statusLEDs.byte &= write;
	updateStatusLEDs();
	mSleep(wtRef); //TODO ? - blocking!	
}

void rotorRight(void)	//hardware level w/o position control (only counting motor pphase)
{
	motorphase --;
	rotorPosition --;
	if (motorphase < 0) motorphase = 7;
	rotorSet(motorphases[motorphase]);

}

void rotorLeft(void)	//hardware level w/o position control (only counting motor pphase)
{
	motorphase ++;
	rotorPosition ++;
	if (motorphase > 7) motorphase = 0;
	rotorSet(motorphases[motorphase]);
}

void rotorLeftRef(void)	//hardware level w/o position control (only counting motor pphase)
{
	motorphase ++;
	rotorPosition ++;
	if (motorphase > 7) motorphase = 0;
	rotorSetRef(motorphases[motorphase]);
}

void laserOn(void)
{
	statusLEDs.byte |= 0b000100;
	updateStatusLEDs();
}

void laserOff(void)
{
	statusLEDs.byte &= 0b111011;
	updateStatusLEDs();
}


void rotorTo(signed int to)	
// values increase counter clock wise ccw, 0 is dead ahead
{
	signed int delta;
	if (to > maxDangerSweep) to = maxDangerSweep;  //TODO parametrisieren; Fehlermeldung?
	if (to < 0 - maxDangerSweep) to = 0 - maxDangerSweep;
	if (to > rotorPosition)
		for (delta = to - rotorPosition; delta > 0; delta--)
			rotorLeft();
	else if (to < rotorPosition)
		for (delta = rotorPosition - to; delta > 0; delta--)
			rotorRight();
}

ISR (INT2_vect)
{
	rotorStop = 1;
}

void rotorReference(void)
{

		for (int i=0; ((rotorStop == 0) && (i < 400)); i++)
		{
			rotorLeftRef();
		}
		rotorRight();
		mSleep(wt);
		rotorRight();
		mSleep(wt);
		rotorStop = 0;
		rotorPosition = endschalter;
		
		if (endschalter > 0)				//TODO? abgleich mit A110
			rotorTo(maxNominalSweep);
		else
			rotorTo(0-maxNominalSweep);

		mSleep(500);
}

void stepRight(void)		//via rotorTo, i.e. with position control
{
	if(rotorPosition - rotorStep > 0-maxDangerSweep)
		rotorTo(rotorPosition - rotorStep);
}

void stepLeft(void)			//via rotorTo, i.e. with position control
{
	if(rotorPosition + rotorStep < maxDangerSweep)
		rotorTo(rotorPosition + rotorStep);
}

int main(void)
{
	initRobotBase();
	powerON();

	//TODO Ort der 
	motorphases[0] = 0b011001; //3 X count up -> rotate ccw
	motorphases[1] = 0b010001; //2
	motorphases[2] = 0b011011; //4 X -> hoher Stromverbrauch
	motorphases[3] = 0b001011; //3
	motorphases[4] = 0b011010; //3 X
	motorphases[5] = 0b010010; //2
	motorphases[6] = 0b011000; //2 X  
	motorphases[7] = 0b001000; //1

	//uint8_t motorphase = 0;

	laserOff();

	rotorReference();
	rotorTo(0);
	laserOn();
	mSleep(1000);
	laserOff();
	stepperOff();

	//int direction = -1;



	const unsigned char XON = 17;
	//const unsigned char XOFF = 19;
	const uint8_t DATAOFFSET = 40;

	char input;

	writeChar(XON);
	clearReceptionBuffer();

	int receivedOffCommand = 0;

	while (!receivedOffCommand)  //TODO! nicht implementeirt, um verwechslung mit rotor/motor off zu vermeiden
	{
		//writeChar(XON);
		while (!getBufferLength());
		input=readChar();
		//writeChar(XOFF);
		{
			if (input == 254)
			{
				laserOn();
			}
			else if (input == 253)
			{
				laserOff();
			}
			else if (input == 252)
			{
				stepRight();
			}
			else if (input == 251) //step left
			{
				stepLeft();
			}
			else if (input == 250)
			{
				laserOff();
				stepRight();
			}
			else if (input == 249)
			{
				laserOff();
				stepLeft();
			}
			else if (input == 244)  //reference
			{
				rotorReference();
				writeChar(244);
			}
			else if (input == 243) //counterposition
			{
				if (endschalter > 0)
					rotorTo(0-maxNominalSweep);
				else
					rotorTo(maxNominalSweep);
				mSleep(750);
			}
			else if (input == 242) // all stop
			{
				//alles stop
				laserOff();
				stepperOff();
			}
			else if (input == 241) //(turn) left degrees
			{
				//writeChar(XON);
				while (!getBufferLength());
				unsigned char myInputParameter=readChar();
				//writeChar(XOFF);

				uint8_t myDegrees = ((uint8_t) myInputParameter) - DATAOFFSET;

				writeChar(myInputParameter);

				powerON();
				rotate(rotationspeed, LEFT, myDegrees, true);				
				//powerOFF;

				writeChar(102);
			}
			else if (input == 240) //(turn) right degrees
			{
				//writeChar(XON);
				while (!getBufferLength());
				unsigned char myInputParameter=readChar();
				//writeChar(XOFF);


				writeChar(myInputParameter);
				uint8_t myDegrees = ((uint8_t) myInputParameter) - DATAOFFSET;

				powerON();
				rotate(rotationspeed, RIGHT, myDegrees, true);
				//powerOFF;

				writeChar(102);
			}
			else if (input == 239) //(move) forward cm 		//TODO Rückmeldung
			{
				//writeChar(XON);
				while (!getBufferLength());
				unsigned char myInputParameter=readChar();
				//writeChar(XOFF);

				writeChar(myInputParameter);

				uint8_t myCmDistance = ((uint8_t) myInputParameter) - DATAOFFSET;

				powerON();
				move(drivespeed, FWD, DIST_CM(myCmDistance), true);
				//powerOFF;

				writeChar(102); //MSG movement complete  //TODO-warum hier kein offset?
			}
			else
			{
				//validCommand = 0;
			}

			//if (validCommand)
				//writeChar(input);


		} //while getbufferlength
/*
			if (uart_status == UART_BUFFER_OK)
			else if ( uart_status == UART_BUFFER_OVERFLOW)
*/
	} //while !receivedOffCommand

	laserOff();
	stepperOff();
	powerOFF();
	return 0; 
}
