
#include <iostream>
#include "cv.h"
#include "highgui.h"

using namespace cv;

#include "arptools.h"
#include "arpFilter.h"

void arpFilter12(const Mat& in, Mat& out, const bool option640)
{
	assert(out.rows == 1);
	assert(in.cols == out.cols);
	assert(in.type() == CV_8UC3);
	assert(out.type() == CV_32FC1);
	
	// extract red channel and rotate 
		
		Mat rotated(in.cols, in.rows, CV_8UC1);
		unsigned char * rotPtr[in.cols];
		for (int inCol = 0; inCol < in.cols; inCol++)	//für jede Spalte der Eingabe, ein Zeiger auf das entspr. (letzte) Element der Ausgabezeile
		{
			rotPtr[inCol] = (unsigned char *) rotated.ptr(inCol) + in.rows - 1; //ATTN
		}



		for (int inRow = 0; inRow < in.rows; inRow++)
		{
			unsigned char * inPtr = (unsigned char *) in.ptr(inRow);
			inPtr += 2; //red
			
			//signed int sparseCounter = 0;
			for (int inCol = 0; inCol < in.cols; inCol++)
			{
				*rotPtr[inCol] = *inPtr; 
				rotPtr[inCol]--;
				inPtr += 3;
			}
		}	
		
		float * outPtr = (float*) out.data;
		
		for (int rotRow = 0; rotRow < rotated.rows; rotRow++)
		{

			float maxR = -100;
			int maxPos = 0;
			
		   /*  mean */
			int mx = 0;
			unsigned char * rotPtr = (unsigned char *) rotated.ptr(rotRow);	
			for (int i = 0; i < rotated.cols; i++) 
			{
			  mx += *rotPtr;
			  rotPtr++;
			}
			mx /= rotated.cols;
			

			rotPtr = (unsigned char *) rotated.ptr(rotRow);	

			int offset;
			if (option640)
				offset = 6;
			else 
				offset = 3;

			float rs[rotated.cols - (2*offset+1)];
		
			for (int delay = 0; delay < rotated.cols - (2*offset+1); delay++)  //TODO - ganzer Bereich wäre nett!
			{
				int r = 0;

				r -= (rotPtr[0] - mx);
				r += 2 * (rotPtr[offset] - mx);
				r -= (rotPtr[2*offset] - mx);
				
				rotPtr++;
			  
				rs[delay] = r;
			   if (r > maxR) { maxR = r; maxPos = delay;}
			   
			} //for delay
			
			
		///SUBPIXEL
				
			float subpix = (float) maxPos;
			float f_pred1, f_pred2,  f_succ1, f_succ2;
			if (maxPos > 0) 
				f_pred1 = rs[maxPos-1]; 
				else f_pred1 = 0;
			if (maxPos > 1) 
				f_pred2 = rs[maxPos-2]; 
				else f_pred2 = 0;
			if (maxPos < rotated.cols - 1) 
				f_succ1 = rs[maxPos + 1]; 
				else f_succ1 = 0;
			if (maxPos < rotated.cols - 2) 
				f_succ2 = rs[maxPos + 2]; 
				else f_succ2 = 0;
			float y0 = f_succ1 / 2 + rs[maxPos] - f_pred1 - f_pred2 / 2;
			float y1 = f_succ2 / 2 + f_succ1 - rs[maxPos] - f_pred1 / 2;
				
			float delta = 0;
			if (y1 != y0)
			{
				delta = y0 / (y0 - y1);
				subpix += delta - 0.5;
			}
			
			*outPtr = subpix + offset;
			
			
			outPtr++;
		} //for rows
	
}

