#include "arpMatch.h"
#include "arpmap.h"
#include "arptools.h"

using namespace cv;

int thrash_lines(const float fov, const int rows)
{
	return (2 * CV_PI - fov) / 2 / 2 / CV_PI * rows + 1;
}

void rowCentersMin(const Mat & in, std::deque <float> & out, const float resolution , const float fov)
{
	assert (in.type() ==CV_32FC1); //?
	
	for(int y = 0; y < in.rows; y++)
	{
		float * ptr = (float *) in.ptr(y);
		int x;
		for (x = 0; x < in.cols; x++)
		{
			if (*ptr > 0)
				break;
			ptr++;
		}
		out.push_back(x);
	}
	

		unsigned int base_size = out.size();
		int shift_lines = out.size() / 4;
		for (int i = 0; i < shift_lines; i++)
		{
			float swap = out[0];
			out.pop_front();
			out.push_back(swap);
		}
		
	for (int i = 0; i < thrash_lines(fov, base_size); i++)
	{
		out.pop_front();
		out.pop_back();
	}
}

void rowCentersLeftAverage(const Mat & in, std::deque <float> & out, const float resolution = CV_PI * 2 / 400, const float fov = 2 * CV_PI)
{
	assert (in.type() ==CV_32FC1); //?
	
	for(int y = 0; y < in.rows; y++)
	{
		float * ptr = (float *) in.ptr(y);
		int x;
		for (x = 0; x < in.cols; x++)
		{
			if (*ptr > 0)
				break;
			ptr++;
		}
		int sum = 0;
		int count = 0;
		for (;x < in.cols; x++)
		{
			if (*ptr == 0)
				break;
			sum += (x+1) * *ptr;						//who's afraid...
			count += (int)*ptr;
			ptr++;
		}
		if (count > 0)
			out.push_back((float) sum / (float) count - 1); //.. of zeroes? TODO
		else
			out.push_back(0);
	}
	

		unsigned int base_size = out.size();
		int shift_lines = out.size() / 4;
		for (int i = 0; i < shift_lines; i++)
		{
			float swap = out[0];
			out.pop_front();
			out.push_back(swap);
		}
		
	for (int i = 0; i < thrash_lines(fov, base_size); i++)
	{
		out.pop_front();
		out.pop_back();
	}
}

void histoPart(Mat & m, const float min, const float max)
{
	assert (m.type() ==CV_32FC1);
	//1. Spaltenhistogramm
		float columnHist[m.cols];
		for (int c = 0; c < m.cols; c++)
			columnHist[c] = 0;

		float total = 0;
		for (int r = 0; r < m.rows; r++)
		{
			float * ptr = (float *) m.ptr(r);
			
			for (int c = 0; c < m.cols; c++)
			{
				columnHist[c] += *ptr;
				total += * ptr;
				ptr++;
			}
		}
		
		
		int c = 0;
		float target = 0;
		for (; c < m.cols; c++)
		{
			target += columnHist[c];
			if (target >= min * total)
				break;
		}
		rectangle(m, Point(0,0), Point(c, m.rows-1), Scalar::all(0), CV_FILLED);	
		std::cout << "histo min " << c << std::endl;
		
		for (c++; c < m.cols; c++)
		{
			target += columnHist[c];
			if (target >= max * total)
				break;
		}
		rectangle(m, Point(c, 0), Point(m.cols-1, m.rows-1), Scalar::all(0), CV_FILLED);
		std::cout << "histo max " << c << std::endl;
	
}

float shiftSAD(std::deque <float> & v_frame, std::deque <float> & v_map, float ROIcenter, float ROIwidth, 
				const bool optionChallengeMatching, const bool subPix)
{

//	float diffSubPix[v_map.size()+1];
	
	float mf = 0;
	float mm = 0;
	int cm = 0;
	int cf = 0;
	for (unsigned int delta = 0; delta < v_map.size(); delta++)
		if (v_map[delta] > 0)
		{
			mm += v_map[delta];
			cm++;
		}
			
	for (unsigned int delta = 0; delta < v_frame.size(); delta++)
		if (v_frame[delta] > 0)
		{
			mf += v_frame[delta];	
			cf++;
		}
	
	float mb = (mf + mm) / (cf + cm);
	mf /= cf;
	mm /= cm;
	
	for (unsigned int delta = 0; delta < v_map.size(); delta++)
	{
		if (v_map[delta] == 0)
			v_map[delta] = mb;
	}
	for (unsigned int delta = 0; delta < v_frame.size(); delta++)
	{
		if (v_frame[delta] == 0)
			v_frame[delta] = mb;
	}
		


	
	Mat curve(v_map.size(), v_map.size(), CV_32FC3);
	curve = Scalar::all(0);
	
	float r[v_map.size()];
	float fov = CV_PI * 2 / 400 * 230;
	
	for(unsigned int d = 0; d < v_map.size(); d++)
	{
		float sxy = 0;
		for (unsigned int i = 0; i < v_frame.size(); i++)
		{

			int jm = (i + d + thrash_lines(fov, v_map.size())) % (unsigned int)v_map.size();

			sxy += (v_map[jm] - v_frame[i]) * (v_map[jm] - v_frame[i]);
			
		}

		r[d] = sxy ;
	}
	

	
	//Gewichtung und Maximum
	while (ROIcenter > 2 * CV_PI)
		ROIcenter -= 2 * CV_PI;
	while (ROIcenter < 0)
		ROIcenter += 2 * CV_PI;
	
	int roid = (2 * CV_PI - ROIcenter) / 2 / CV_PI * v_map.size();
	float bestrInit = 99999999;
	float bestr = bestrInit;
	float bestd = roid;
	std::cout << " ROIcenter " << ROIcenter ;
	std::cout << " roid " << roid;
	
	std::cout << "ROIwidth " << ROIwidth << std::endl;
	ROIwidth = ROIwidth / (2 * CV_PI);
	while (ROIwidth < 0)
		ROIwidth+=1;
	while (ROIwidth > 1)
		ROIwidth-=1;
		
	ROIwidth /= 4;
	ROIwidth *= v_map.size();
	int ac1 = ROIwidth;
	int ac2 = v_map.size() - 1 - ROIwidth;

	
	if (optionChallengeMatching)
	{
		ac2 = ac2 - 10 - ac1;
		ac1 = ac1 + 10 + ac1;
	}
	std::cout << "ac1 " << ac1 << ", ac2 " << ac2 << " of " << v_map.size() << std::endl;
	
	unsigned int bestindex = (unsigned int) bestd;
	
	for(unsigned int d = 0; d < v_map.size(); d++)
	{
		int index = (roid + d) % v_map.size();
		if ((d <= ac1) || (d >= ac2))
		{
			if (r[index] < bestr)
			{
				bestr = r[index];
				bestindex = index;
			}
		}
	}
	
	
	bestd = bestindex;
	

	std::cout << "bestd " << bestd << std::endl;
	
	//SUBPIXEL
			
			float shift = (float)bestd;
			std::cout << "shift before subpix " << shift << std::endl;
			
 			std::cout <<"indices " << (bestindex +  v_map.size() - 1) % v_map.size() << " , " 
 						<< bestindex << " , " << (bestindex + 1) % v_map.size() << std::endl;
			float a = r[(bestindex - 1 + v_map.size()) % v_map.size()];
			float b = r[bestindex];
			float c = r[(bestindex + 1) % v_map.size()];
			std::cout << "values " << a << " " << b << " " << c << std::endl;
			
			float abl1 = b-a;
			float abl2 = c-b;
			
			float subPixShift = abl1 / (abl1 - abl2);
			
			std::cout << "subPixShift " << subPixShift << std::endl;
			
			if (subPix)
				shift -= - 0.5 + (a-c) / b;

				
			std::cout << "shift after subpix " << shift << std::endl;
	//Pixel -> Bogenmaß
	
		shift  /= (float)v_map.size();
		std::cout << "shift radians" << shift << std::endl;

	return shift ;
}


float radialMatching(const Mat & worldFrame, const Mat & worldMap, const Pose & position_ist, const Pose & rotationCenter, 
						vector <Mat> & visuals, const float unitRotationCenterDistance, const bool optionChallengeMatching)
{
	int matchSize = 200;
	
	Pose np;
	np.x = np.y = np.r = 0;
	Pose unitCenter;
	unitCenter = getRotationCenter (np, unitRotationCenterDistance);
	
	Pose centerFrameInt, centerFrameFloat, centerMapInt, centerMapFloat;
	centerMapFloat.x = std::modf(rotationCenter.x, &centerMapInt.x);
	centerMapFloat.y = std::modf(rotationCenter.y, &centerMapInt.y);
	centerFrameFloat.x = std::modf(unitCenter.x, &centerFrameInt.x);
	centerFrameFloat.y = std::modf(unitCenter.y, &centerFrameInt.y);
	
	std::cout << "worldFrame.size().width / 2 - matchSize / 2 + centerFrameInt.x " << worldFrame.size().width / 2 - matchSize / 2 + centerFrameInt.x << std::endl;
	std::cout << "worldFrame.size().height / 2 - matchSize / 2 + centerFrameInt.y " << worldFrame.size().height / 2 - matchSize / 2 + centerFrameInt.y << std::endl;
	std::cout << "worldMap.size().width / 2 - matchSize / 2 + centerMapInt.x " << worldMap.size().width / 2 - matchSize / 2 + centerMapInt.x << std::endl;
	std::cout << "worldMap.size().height / 2 - matchSize / 2 + centerMapInt.y " << worldMap.size().height / 2 - matchSize / 2 + centerMapInt.y << std::endl;

	Rect frameRoiRect(	worldFrame.size().width / 2 - matchSize / 2 + centerFrameInt.x,
						worldFrame.size().height / 2 - matchSize / 2 + centerFrameInt.y,
						matchSize, matchSize);
	Rect mapRoiRect(	worldMap.size().width / 2 - matchSize / 2 + centerMapInt.x,
						worldMap.size().height / 2 - matchSize / 2 + centerMapInt.y,
						matchSize, matchSize);
			

	Mat mapRoiSmall (worldMap, mapRoiRect);
	Mat frameRoiSmall (worldFrame, frameRoiRect);
	
	Mat mapRoi(mapRoiSmall.cols * 2, mapRoiSmall.rows * 2, CV_32FC1);
	Mat frameRoi(frameRoiSmall.cols * 2, frameRoiSmall.rows * 2, CV_32FC1);
	shiftFloatMat(mapRoiSmall, mapRoi, Point(mapRoiSmall.rows / 2, mapRoiSmall.cols /2)); 
	shiftFloatMat(frameRoiSmall, frameRoi, Point(frameRoiSmall.rows / 2, frameRoiSmall.cols / 2));
	////////////////////////////////////////
	matchSize *= 2;   //ganz schlechter Stil
	////////////////////////////////////////
	
	CvMat mapRoiLegacy = mapRoi;
	CvMat frameRoiLegacy = frameRoi;
	CvMat* mapPolarLegacy = cvCreateMat(mapRoi.cols, mapRoi.rows, CV_32FC1);
	CvMat* framePolarLegacy = cvCreateMat(frameRoi.cols, frameRoi.rows, CV_32FC1);
	double logPolarScale = 40;
	
	std::cout << "centerFrame: " <<	centerFrameInt.x << ". " << centerFrameFloat.x << ";  "
		<< centerFrameInt.y << ". " << centerFrameFloat.y << std::endl;
		
	std::cout << "centerMap  : " << centerMapInt.x << ". " << centerMapFloat.x << ";  "		
		<< centerMapInt.y << ". " << centerMapFloat.y << std::endl;

	float ccorr;
	if (matchSize % 2 == 0)
		ccorr = -0.5;
	else
		ccorr = 0;

	std::cout << "mapRoi.cols " << mapRoi.cols  << std::endl;
	std::cout << "frameRoi.cols " << frameRoi.cols  << std::endl;
	std::cout << "matchSize / 2 + centerFrameFloat.x + ccorr" << matchSize / 2 + centerFrameFloat.x + ccorr<< std::endl;
	std::cout << "matchSize / 2 + centerFrameFloat.y + ccorr" << matchSize / 2 + centerFrameFloat.y + ccorr<< std::endl;
	std::cout << "matchSize / 2 + centerMapFloat.x + ccorr" << matchSize / 2 + centerMapFloat.x + ccorr<< std::endl;
	std::cout << "matchSize / 2 + centerMapFloat.y + ccorr " << matchSize / 2 + centerMapFloat.y + ccorr<< std::endl;
		
	cvLogPolar(& frameRoiLegacy, framePolarLegacy, 
				cvPoint2D32f(matchSize / 2 + centerFrameFloat.x + ccorr, matchSize / 2 + centerFrameFloat.y + ccorr), 
				logPolarScale,	CV_INTER_LINEAR + CV_WARP_FILL_OUTLIERS); //
	cvLogPolar(& mapRoiLegacy, mapPolarLegacy, 
				cvPoint2D32f(matchSize / 2 + centerMapFloat.x + ccorr, matchSize / 2 + centerMapFloat.y + ccorr), 
				 logPolarScale,	CV_INTER_LINEAR + CV_WARP_FILL_OUTLIERS); // 
	
	Mat framePolar(framePolarLegacy);	//does not copy data
	Mat mapPolar(mapPolarLegacy);

	//histoPart(framePolar, .9, 1.0);
	//histoPart(mapPolar, .9, 1.0);
	
	visuals.push_back(frameRoi.clone());
		visuals.push_back(mapRoi.clone());
	visuals.push_back(Mat(framePolar).clone());
		visuals.push_back(Mat(mapPolar).clone());

	std::deque <float> frameRadialCenters;
	std::deque <float> mapRadialCenters;

	rowCentersLeftAverage(mapPolar, mapRadialCenters);
	float fov =  2 * CV_PI / 400 * 230;
	rowCentersLeftAverage(Mat(framePolar), frameRadialCenters, 2 * CV_PI / 400, fov);
	
	float deltaR;
	deltaR = rotationCenter.r - position_ist.r;
	while (deltaR < 0)
		deltaR += 2 * CV_PI;
	while (deltaR > 2 * CV_PI)
		deltaR -= 2 * CV_PI;
	if (deltaR > CV_PI)				//ATTN TODO
		deltaR = 2 * CV_PI - deltaR;
	deltaR = std::abs(deltaR);
	
	std::cerr << "rotationCenter.r " << rotationCenter.r << std::endl;
	std::cerr << "deltaR" << deltaR << std::endl;

 	float shift = shiftSAD(frameRadialCenters, mapRadialCenters, rotationCenter.r, deltaR, optionChallengeMatching, false);	//TODO: Benennung falsch herum
 	float phi = (1.f - shift) * 2 * CV_PI;
 	std::cout << phi << " phi" << std::endl;
 
 	return phi;
}
