#ifndef _ARP_MATCH_H
#define _ARP_MATCH_H

#include "cv.h"
#include <deque>
#include "scanner.h"
#include "arp_common.h"
#include "arpmap.h"

//Das Ergebnis ist eine Drehung im Bogenmaß relativ zu worldMap
float radialMatching(	const Mat & worldFrame, const Mat & worldMap, const Pose & oldPose, const Pose & targetPose, 
						vector <Mat> & visuals, const float unitRotationCenter, const bool optionChallengeMatching);

void rowCentersMin(const Mat & in, std::deque <float> & out, const float resolution = CV_PI * 2 / 400, const float fov = 2 * CV_PI);


float shiftSAD(std::deque <float> & v_frame, std::deque <float> & v_map, float ROI, float ROIangleAbsolute, 
				const bool optionChallengeMatching, const bool subPix);
#endif