#include "arpVisual.h"
#include <iostream>

void getCutView(const Mat & world, Mat & Bildnis)
{
	int scale = 2;
	Bildnis = Scalar::all(0);

	for (int i = world.size().height - 1; i >= 0; i--)
	{
		float * worldptr = (float*) world.ptr(i);
		worldptr++;
		Point2f p(Bildnis.size().height - (*(worldptr++) * scale + Bildnis.size().height / 2), 
					*(worldptr++) * scale + Bildnis.size().width / 2);
		line(Bildnis, p, p, Scalar::all(255));
	}

}

void drawPositionCircles(Mat & m, const Pose & p0, const Pose & p1)
{
	int w = m.cols / 2;
	int h = m.rows / 2;
	circle(m, Point(p0.x + w, p0.y + h), 6, Scalar::all(255));
	circle(m, Point(p0.x + w, p0.y + h), 7, Scalar::all(0));
	circle(m, Point(p1.x + w, p1.y + h), 5, Scalar::all(255));
	circle(m, Point(p1.x + w, p1.y + h), 4, Scalar::all(0));
}

void drawHough(const vector <Vec4i> & cart, Mat & m)
{
	for(int i = 0; i < std::min((int)cart.size(), 10); i++)  //TODO
	{
		line(m, Point(cart[i][0],cart[i][1]), Point(cart[i][2], cart[i][3]), Scalar::all(255));
	}
}

void show(const vector <Mat> & m)
{
	for (unsigned int i = 0; i < m.size(); i++)
	{
		std::stringstream foo;
		foo << i;
		imshow(foo.str(), m[i]);
	}
	waitKey(1000);
}

void showCut(const Mat & worldCut, const Mat & images_j, const Mat & despeckled_j)
{
	Mat cutView(Size(512, 512), CV_8UC1, Scalar::all(0));
	getCutView(worldCut, cutView);

	imshow("image", images_j);					

	Mat filterView(images_j.size(), CV_32FC1, Scalar::all(0));

	float* ptr = (float*)despeckled_j.data;
	for (int i = 0; i < images_j.cols; i++)
	{
		Point P(i, images_j.rows - (int)*(ptr++));
		line(filterView, P, P, Scalar::all(255));
	}

	imshow("filterView", filterView);

	imshow("cutView", cutView);
}
		
// crosshairs considered harmful!
void crosshair(Mat &m)
{
	// TODO if (m.type() == CV_32FC1) ||
	
				line(m, Point(m.cols/2,0), Point(m.cols/2, m.cols-1), Scalar::all(64000));
				line(m, Point(0,m.cols/2), Point(m.cols-1, m.cols/2), Scalar::all(64000));
}
