#include "arp_file.h"
#include "arptools.h"
#include <iomanip>

/*
 * 
 * 
 */
void writeSTL(const vector <Mat> & data, const String pathDir)
{
		string path = pathDir;
		assertSlash(path);
		path.append("arp.txt.stl");
		
		std::ofstream fout(path.c_str());
		if (!fout){std::cerr<<"could not open stl for writing: " << path << std::endl; exit(EXIT_FAILURE);}
		
		float k1,k2,k3;
		
		fout << "solid " << path << std::endl;
		for (unsigned int m = 0; m < data.size(); m++)
		{
			for (int r = 0; r < data[m].rows; r++ )
			{
				
				float * p = (float *) data[m].ptr(r);

				k1 = p[0];
				k2 = p[1];
				k3 = p[2];
				
				if ((k1 != 0) || (k2 != 0) || (k3 != 0))
				{
					fout << "facet normal 1.0 1.0 1.0" << std::endl;
					fout << "outer loop" << std::endl;
					fout << std::scientific << "vertex " << k1 << " " << k2 << " " << k3 << std::endl;
					fout << std::scientific << "vertex " << k1 << " " << k2 << " " << k3 << std::endl;
					fout << std::scientific << "vertex " << k1 << " " << k2 << " " << k3 << std::endl;
					fout << "std::endloop" << std::endl;
					fout << "endfacet" << std::endl;
					
				}
			}
		}
		fout << "endsolid " << path << std::endl;
		fout.close();
}

void writeSTL_KNN(const Mat & data, const Mat & indices, const String pathDir)
{
		string path = pathDir;
		assertSlash(path);
		path.append("arp-KNN.txt.stl");
		
		std::ofstream fout(path.c_str());
		if (!fout){std::cerr<<"could not open stl for writing: " << path << std::endl; exit(EXIT_FAILURE);}
				
		fout << "solid " << path << std::endl;
		for (int r = 0; r < data.rows; r++ )
		{
			int * index = (int *) indices.ptr(r);
			float * p = (float *) data.ptr(r);
			float * q = (float *) data.ptr(index[0]);
			float * r = (float *) data.ptr(index[1]);

			fout << "facet normal 1.0 1.0 1.0" << std::endl;
			fout << "outer loop" << std::endl;
			fout << std::scientific << "vertex " << p[0] << " " << p[1] << " " << 0 << std::endl;
			fout << std::scientific << "vertex " << q[0] << " " << q[1] << " " << 0 << std::endl;
			fout << std::scientific << "vertex " << r[0] << " " << r[1] << " " << 0 << std::endl;
			fout << "endloop" << std::endl;
			fout << "endfacet" << std::endl;
		}
		fout << "endsolid " << path << std::endl;
		fout.close();
}



CvMat* loadCalibrationData(string filename, string indexname)
{

	filename = "./" + filename;
	
	CvFileStorage* fs = cvOpenFileStorage(filename.c_str(), 0, CV_STORAGE_READ);
	if(fs == 0)
	{
		std::cerr << "could not open " << filename << std::endl;
		exit(EXIT_FAILURE);
	}
	CvMat* intermediate = (CvMat*) cvReadByName(fs, 0, indexname.c_str());
	if (intermediate == 0)
	{
		std::cerr << "could not read requested data from open file" << filename << std::endl;
		exit(EXIT_FAILURE);
	}
	cvReleaseFileStorage(&fs);
	return intermediate;
}

void assertSlash(String & s)
{
	if (s.compare(s.length()-1, 1, "/"))
		s.append("/");
}

void assertSlash(std::stringstream & ss)
{
	if (ss.str().compare(ss.str().length()-1, 1, "/"))
		ss << "/";
}


void saveCameraImages(const vector <Mat> & images, const String path)
{

	for (unsigned int i = 0; i < images.size(); i++)
	{
		std::stringstream filename;
		filename << path;
		assertSlash(filename);
		filename << i + 100000 << ".png";		//unix-specifix
		if (!imwrite(filename.str(), images[i]))
			std::cerr << "Attention: could not write " << filename.str() << std::endl;

	}
		
}


void loadFileset(const std::stringstream & fileset, vector <Mat> & images, const int imageCount, const bool option640)			
{
	for (int i = 0; i < imageCount; i++)
	{
		std::stringstream filename;
		filename << fileset.str() << "/" << i + 100000 << ".png";		//unix-specifix
		Mat m = imread(filename.str(), CV_LOAD_IMAGE_UNCHANGED);
		Mat n;
		
		if ((option640) && (m.cols == 320))
		{
			std::cerr << "Error: set option for 640 px fileset but input is 320px. exiting" << std::endl;
			exit(EXIT_FAILURE);
		}
		
		if (!(option640) && (m.cols == 640))
		{
			resize(m,n,Size(320, 240));
			m = n.clone();
			std::cerr << "resizing 640 px image to 320" << std::endl;
		}

		images.push_back(m);		//TODO succcess?
	}
}

String timeString()
{
	std::stringstream ss;

	time_t * t = new(time_t);
	time(t);
	struct tm * tt = new(struct tm);
	tt = localtime(t);
	ss 	<< std::setfill('0') 
		<< std::setw(2) << tt->tm_mon + 1 
		<< std::setw(2) << tt->tm_mday << "_" 
		<< std::setw(2) << tt->tm_hour
		<< std::setw(2) << tt->tm_min
		<< std::setw(2) << tt->tm_sec;
	return ss.str();
}

void saveVisuals(const vector <Mat> & visuals, const String path)
{
	std::stringstream base;
	base << path;
	assertSlash(base);
	for (unsigned int i = 0; i < visuals.size(); i++)
	{
		std::stringstream filename;
		filename << base.str() << i << ".png";
		if (!imwrite(filename.str(), visuals[i]))
			std::cerr << "could not write visuals[" << i << "] to server directory" << std::endl;
	}
}

void createLogDir(const std::stringstream & baseLogDir, int cycleCount, std::stringstream & logSubDir)
{
	logSubDir << baseLogDir.str();
	assertSlash(logSubDir);
	
	std::stringstream postfix;
	postfix << std::setfill('0') << std::setw(4) << cycleCount;
	logSubDir << postfix.str();
	assertSlash(logSubDir);
	

	if (chdir(baseLogDir.str().c_str()))
	{
		std::cerr << "could not descend in log dir " << baseLogDir.str() << std::endl;
		exit(EXIT_FAILURE);
	}
	if (mkdir(postfix.str().c_str(), 0777)) 	//false bei erfolg!
	{
		std::cerr << "could not create logSub directory" << std::endl; 
		chdir("..");
		exit(EXIT_FAILURE);
	}
	chdir("..");
}