#ifndef _ARP_FILE_H
#define _ARP_FILE_H

#include <stdio.h>
#include "cv.h"
#include "highgui.h"
#include <iostream>
#include <fstream>

using namespace cv;

String timeString();
void assertSlash(std::string & s);
void assertSlash(std::stringstream & ss);

CvMat* loadCalibrationData(std::string filename, std::string indexname);
void loadFileset(const std::stringstream & fileset, vector <Mat> & images, const int imageCount, const bool option640);

void saveCameraImages(const vector <Mat> & images, const std::string path);
void writeSTL(const vector <Mat> & data, const std::string path);
void saveVisuals(const vector <Mat> & visuals, const std::string path);

void createLogDir(const  std::stringstream & baseLogDir, int cycle, std::stringstream & logSubDir);
void writeSTL_KNN(const Mat & data, const Mat & indices, const String pathDir);

#endif