#include "arpmap.h"

void relaxFloorGrid(Mat & m)
{
	Mat temp = m.clone();
	for (int y = 0; y < m.cols - 1; y++)
	{
		float * mp = (float *) m.ptr(y);
		for (int x = 0; x < m.rows - 1; x++)
		{
			if(mp[x] == 1.0)
			{
				temp.at<float>((int) (y), (int)(x)) = 1.0;
				temp.at<float>((int) (y+1), (int)(x)) = 1.0;
				temp.at<float>((int) (y), (int)(x+1)) = 1.0;
				temp.at<float>((int) (y+1), (int)(x+1)) = 1.0;
			}
		}
	}
	m = temp.clone();
}


void shrinkFloorGrid(Mat & m, /*const Pose & position,*/ float scannerStandoff)
{
	Mat floorEroded(m.size(), m.type());
	////////////////////// TODO ////////////////////////
	/////////////////// gefährlich /////////////////////
	//circle(m, Point(m.cols/2 + position.x, m.rows / 2 + position.y), scannerStandoff, Scalar::all(255), -1); //TODO!
	circle(m, Point(m.cols/2 , m.rows / 2) , scannerStandoff, Scalar::all(255), -1); //TODO!
	Mat nullMat; //TODO /?
	erode(m, m, nullMat, Point(-1,-1), 6); ///TODO ?5?
	////////////////////////////////////////////////////////	
}


void occCheck(const vector <Mat> & data, Mat & floorGrid, Mat& wallGrid, float scale)
{
	float x, y;
	int hx = floorGrid.cols / 2;
	int hy = floorGrid.rows / 2;
	float range = (float) floorGrid.rows / 2;
	floorGrid = Scalar::all(0);
	wallGrid = Scalar::all(0);

	for(unsigned int m = 0; m < data.size(); m++)
	{
		for (int r = 0; r < data[m].rows; r++)
		{
			const float * p = (float*) data[m].ptr(r);
			x = scale * p[2];
			y = scale * p[0];
				
			if((x > -range) &&(x < range-1 )&&(y > -range)&&(y < range-1 )) //TODO sanity check
			{
				x += hx;
				y += hy;
					//	>= 1.5
				if((p[1] > -1) && (p[1] < 1))		//-1.5 // -2	//TODO parametrisieren
				{
					if (floorGrid.at<float>((int) (y), (int)(x)) != -999)		//TODO
						floorGrid.at<float>((int) (y), (int)(x))++;
				}
					// < 0
				if((p[1] < -3))//	&& (p[1] > -12))	// 2 * 18cm höhe / cmPerUnit		//TODO parametrisieren -- und warum so hoch?
				{
					wallGrid.at<float>((int) (y), (int)(x))++;
						floorGrid.at<float>((int) (y), (int)(x)) = -999; //"wall votes against floor" //TODO
				}
				
			}
		}
	}
}

Point2f maximizePath(const Mat& grid, Point2f p0, Point2f p1)
{
	LineIterator it(grid, p0, p1, 8);
	vector<float> buf(it.count);
	for(int i = 0; i < it.count; i++, ++it)
	{
		buf[i] = *(float*)*it;
	}
	
	int maxCount = 0;
	float maxValue = 0;
	////////////// TODO //////////////////////
	int minrange = 5;
	////////////////////////////////////////////
	for(int i = minrange; i < it.count; i++, ++it)
		if (buf[i] >= maxCount)
		{
			maxValue = buf[i];
			maxCount = i;
		}
		
	float d = sqrt((p0.x - p1.x)*(p0.x - p1.x) + (p0.y - p1.y)*(p0.y - p1.y)) * it.count / maxCount;

	Point2f P;
	P.x = p0.x + d * (p1.x - p0.x);
	P.y = p0.y = d * (p1.y - p0.y);
	return P;
}

float pathSum(const Mat & lri, Point2f p0, Point2f p1) //lri: long range interest grid
{
	assert(lri.type() == CV_32FC1);
	
	LineIterator it(lri, p0, p1, 8);
	float counter = 0;
	for(int i = 0; i < it.count; i++, ++it)
	{
		counter += *(float*)*it;
	}
	return counter;	
}

float vorzugsrichtungAbsolut(const Mat & IG, Pose reference)  //ig: interest grid 
{
	
	//Point2f bestPoint;
	float bestValue = -1;
	float returnValue;
	Point2f p0(reference.x + IG.cols / 2, reference.y + IG.rows / 2);
	Point2f p1(0,0);
	//float tRange = CV_PI;
	float tStep = CV_PI / 200 * 4; //4 schritte
	//float tStart = reference.r;
	float bestRef = reference.r;
	for (float t = - CV_PI; t < CV_PI; t += tStep)
	{
		p1.x = p0.x - sin(t) * (400 / cmPerUnit);
		p1.y = p0.y - cos(t) * (400 / cmPerUnit);	//TODO parametrisieren scannerCutoff
		returnValue = pathSum(IG, p0, p1);
		if (returnValue > bestValue)
		{
			bestValue = returnValue;
			//bestPoint = p1;
			bestRef = t;
		}
	}
	//TODO: Fkt. wie auch Bestimmung d. Fahrtrichtung; cartPolar?
	//std::cerr << "vorzugsrichtung: bestPoint: " << bestPoint.x << ", " << bestPoint.y;
	//float ret = fastAtan2((float) (bestPoint.y - (reference.y + IG.rows / 2)),
	//							float (bestPoint.x - (reference.x + IG.cols / 2))); // - reference.r;		
	std::cerr << "vorzugsrichtung absolut: "<<bestRef << std::endl;
	//std::cout << " atan: " << ret;
	//ret *= (CV_PI / 180.f);
	//std::cout << " radians: " << ret << std::endl;
	
	return  bestRef;

}

void updateMap(const Mat& frame, Mat& map, const Pose & position, bool writeZeros)
{
	
	//TODO Massstabsfaktor?

	float deltaX = map.cols / 2 - frame.cols / 2;
	float deltaY = map.rows / 2 - frame.rows / 2;
	deltaX += position.x;
	deltaY += position.y;

	Mat tempFrame(frame.size(), frame.type());
	
	float rotation = position.r;
	while (rotation < 0)
		rotation += 2 * CV_PI;
	while (rotation > 2 * CV_PI)
		rotation -= 2 * CV_PI;

	
	//HACK! 3.96 parametrisieren!
	//Mat T = getRotationMatrix2D( Point2f (frame.cols / 2, frame.rows / 2 + 3.96), position.r * 180 / CV_PI, 1);
	Mat T = getRotationMatrix2D( Point2f (frame.cols / 2, frame.rows / 2), position.r * 180 / CV_PI, 1);
	warpAffine(frame,tempFrame,T,tempFrame.size());		//TODO-wird da was abgeschnitten?
	
	Mat tempMap(map.size(), map.type());
	for(int y = 0; y < tempFrame.rows; y++) //TODO?
	{
		float * p = (float *) tempFrame.ptr(y);
		for (int x = 0; x < tempFrame.cols; x++)
		{
			if((writeZeros) || (p[x] != 0))  //TODO time?
			{
				line(tempMap, Point(x + deltaX, y+deltaY), Point(x+deltaX,y+deltaY), p[x]);
			}
		}
	}
	 
	max(map, tempMap, map); 
}

void buildRayGrid(const Mat & in, Mat & out)
{
	assert(in.cols == out.cols);
	assert(in.rows == out.rows);
	assert(in.type() == out.type());
	
	/*
	int end = 116;//400 / 3.50 //TODO
	//end /= 2;
	
	Point2f c(in.cols/2, in.rows/2);
	
	int x = 0;
	for (int x = -end; x < end; x ++)
	{
		//if (abs (x -10) < 10) x +=10; //TODO totaler hack
		if (pathSum(in, c, Point2f(c.x + x, c.x + end)) == 0)
			line(out, c, Point(c.x + x, c.x + end), Scalar::all(255));
		if (pathSum(in, c, Point2f(c.x + x, c.x - end)) == 0)
			line(out, c, Point(c.x + x, c.x - end), Scalar::all(255));
	
		if (pathSum(in, c, Point2f(c.y + end, c.y + x)) == 0)
			line(out, c, Point(c.y + end, c.y + x), Scalar::all(255));
		if (pathSum(in, c, Point2f(c.y - end, c.y + x)) == 0)
			line(out, c, Point(c.y - end, c.y + x), Scalar::all(255));
			
		//if (pathSum(in, c, Point2f(x, c.y - end - x)) == 0)
		//	line(out, c, Point2f(x, c.y - end - x), Scalar::all(255));		
		//if (pathSum(in, c, Point2f(x, c.y + end + x)) == 0)
		//	line(out, c, Point2f(x, c.y + end + x), Scalar::all(255));				
		//if (pathSum(in, c, Point2f(c.x + end + x, x)) == 0)
		//	line(out, c, Point2f(c.x + end + x,  x), Scalar::all(255));				
		//if (pathSum(in, c, Point2f(c.x + end + x, c.y + end + y)) == 0)
		//	line(out, c, Point2f(c.x + end + x, c.y + end + y), Scalar::all(255));				
		//
	}
	*/

	

	for (int y = 0; y < in.rows; y++)
	{
		float * inp = (float*) in.ptr(y);
		for (int x = 0; x < in.cols; x ++)
		{
			if (inp[x] > 0)
				line(out, Point(in.cols / 2, in.rows / 2), Point(x,y), Scalar::all(255));
		}
	}
}

void bestTargetPose(const Mat & SRT, const Mat & LRT, const Pose & P, Pose & returnPose, const float evasiveTurn)  //ShortRangeTarget, FloorGridEroded;
{
	//1. Bestimmung d. maximal möglichen Geradeausfahrt im relativen Frame-System
	
			Point2f p0, p1;

			p0.x = SRT.cols / 2 + P.x;
			p0.y = SRT.rows / 2 + P.y;

			p1.x = p0.x - sin(P.r) * (SRT.cols / 2 - 1); //TODO-nicht volles SRT genutzt
			p1.y = p0.y - cos(P.r) * (SRT.rows / 2 - 1);
				
			std::cout << "p0: " << p0.x << "," << p0.y << "   p1: " <<p1.x << "," <<p1.y<< std::endl;
			
			LineIterator it(SRT, p0, p1, 8);
			float maxVal = 0;
			float maxPos = 0;
			float thisVal;
			/////////////////// TODO /////////////
			
				float realRange = sqrt((p0.x-p1.x) * (p0.x-p1.x) + (p0.y - p1.y) * (p0.y - p1.y));
	
				int minrange = (float)it.count / realRange * (14.9/cmPerUnit) + 1;
			
			///////////////////////////////////////
			for (int i = 0; i < minrange; i++)
			{
					++it;	//line iterator um minRange nach vorn
			}
			
			for(int i = minrange; i < it.count; i++)
			{
				thisVal = *(float*)*it;
				if (thisVal == 0)
					break;
				if (thisVal >= maxVal) //nicht: >
				{
					maxVal = thisVal;
					maxPos = i;
				}
				++it;
			}	
			
			std :: cout << "max count " << maxPos << " in line iterator w. |it|=" << it.count << std::endl;
	
	// 2. bestimme den Rückgabewert


		returnPose.x = P.x;		//...relativ zur originalen Position
		returnPose.y = P.y;
			
		returnPose.r = P.r;
		if (maxPos < 1)
		{
			//x,y bleiben gleich
			returnPose.r = P.r + evasiveTurn;
			std::cout << "no free area, turning away" << std::endl;
		}
		else 
		{
			
			float rangeFactor = maxPos / it.count;
			std::cout << "rangeFactor " << rangeFactor << std::endl;
			float deltaX = rangeFactor * (float)(p1.x - p0.x);
			float deltaY = rangeFactor * (float)(p1.y - p0.y);
			//float rotDeltaX = deltaY * sin(P.r) - deltaX * cos(P.r);
			//float rotDeltaY = deltaX * sin(P.r) + deltaY * cos(P.r);
			
			returnPose.r = vorzugsrichtungAbsolut(LRT, returnPose);	//vorsicht, r.P. hat sich hier selbst als Input
			returnPose.x = P.x + deltaX;
			returnPose.y = P.y + deltaY;

		}
		
	
	while (returnPose.r > 2 * CV_PI)
		returnPose.r -= 2 * CV_PI;
	while (returnPose.r < 0)
		returnPose.r += 2 * CV_PI;		

	std::cout << "returnPose " << returnPose.x << ", " << returnPose.y << ", " << returnPose.r << std::endl;
}

Pose getRotationCenter(const Pose & position, const float d)
{
	Pose returnPose;
	returnPose.x = position.x + d * sin(position.r); //Umkehrung
	returnPose.y = position.y + d * cos(position.r); // 
	returnPose.r = position.r;
	return returnPose;
}

Pose rotate(const Pose & center, const float absoluteTargetAngle, const Pose & oldPose, const float d)

{
	Pose newPose;
	newPose.x = center.x - d * sin(absoluteTargetAngle);
	newPose.y = center.y - d * cos(absoluteTargetAngle);	
	newPose.r = absoluteTargetAngle;

	return newPose;
}
