#ifndef _ARP_MAP_H
#define _ARP_MAP_H

#include <stdio.h>
#include "cv.h"
#include "highgui.h"
#include <iostream>
#include <fstream>
#include "arp_common.h"

#include "scanner.h"

using namespace cv;

void occCheck(const vector <Mat> & data, Mat & occGrid, Mat & wallGrid, float scale);

Point2f bestTargetPoint(const Mat & occGrid, bool preferStraight);

void updateMap(const Mat& frame, Mat& map, const Pose & position, bool writeZeros = false);

void buildRayGrid(const Mat & in, Mat & out);

float vorzugsrichtungAbsolut(const Mat & lri, Pose position);

void relaxFloorGrid(Mat & m);
void shrinkFloorGrid(Mat & m, /*const Pose & position,*/ float scannerStandoff);

void bestTargetPose(const Mat & SRT, const Mat & LRT, const Pose & P, Pose & returnPose, const float evasiveTurn);

Pose rotate(const Pose & center, const float absoluteTargetAngle, const Pose & oldPose, const float offset);
Pose getRotationCenter(const Pose & position, const float offset);

#endif