#include "arpserial.h"


serialCom::serialCom(){}
	
void serialCom::init()
{
	serialstream.Open("/dev/ttyUSB0");
	if (not serialstream.IsOpen())
	{
		serialstream.Open("/dev/ttyUSB1");
		if (not serialstream.IsOpen())
		{
				// TODO - IF SERIAL REQUIRED
				std::cerr << "could not open a serial stream" << std::endl;
				exit(EXIT_FAILURE);
		}
		else
			std::cerr << "ttyUSB1 open" << std::endl;
	}
	else
		std::cerr << "ttyUSB0 open" << std::endl;
			
	serialstream.SetBaudRate(SerialStreamBuf::BAUD_38400);
	serialstream.SetCharSize(SerialStreamBuf::CHAR_SIZE_8);
	serialstream.SetFlowControl(SerialStreamBuf::FLOW_CONTROL_NONE);	
	serialstream.SetNumOfStopBits(1) ;
}

serialCom::~serialCom()
{
	serialstream << CMD_all_stop;
	serialstream.Close();
}

void serialCom::sendWithTicket(unsigned char command)
{
		serialstream << command;
		serialstream >> c;
}

void serialCom::sendSimple(unsigned char command)
{
		serialstream << command;
}

unsigned char serialCom::receive()
{
	serialstream >> c;
	return c;
}