#include "arptools.h"

void printFloatMat(CvMat* m)	//TODO generalisieren für datentypen
{
	float * p = m->data.fl;
	for(int i = m->height; i > 0; i--)
	{
		for(int j = m->width; j > 0; j--)		//TODO doesen't support multichannel
		{
				printf("%f ", *p++);
		}
		printf("\n");
	}
}

void printFloatMat(const Mat& m)	//TODO generalisieren für datentypen
{
	for(int i = 0; i < m.size().height; i++)
	{
		float * p = (float*) m.ptr(i);
		for(int j = 0; j < m.size().width; j++)
		{
			for(int k = 0; k < m.channels(); k++)
			{
				printf("%f ", p[j * m.channels() + k]);		//TODO iteratoren
			}
		}
		printf("\n");
	}
}


void printIntMat(const Mat& m)	//TODO generalisieren für datentypen
{
	for(int i = 0; i < m.size().height; i++)
	{
		int * p = (int*) m.ptr(i);
		for(int j = 0; j < m.size().width; j++)
		{
			for(int k = 0; k < m.channels(); k++)
			{
				printf("%d ", p[j * m.channels() + k]);		//TODO iteratoren
			}
		}
		printf("\n");
	}
}

double tick(){		//systemzeit in sekunden  //TODO: schneller rechnen mit millisekunden (long int)?
	struct timespec tp;
	clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &tp);
	return (tp.tv_sec + tp.tv_nsec / 1e9);
}

void shiftFloatMat(const Mat & in, Mat & out, Point P)
{
	assert(in.type() == CV_32FC1);
	assert(out.type() == in.type());

	out = Scalar::all(0);
	
	Rect ri = Rect(0, 0, in.cols, in.rows) & Rect(-P.x, -P.y, out.cols, out.rows);
	Rect ro = Rect(0, 0, out.cols, out.rows) & Rect(P.x, P.y, in.cols, in.rows);
	for (int y = 0; y < ro.height; y++)
	{
		float * outPtr = (float*) out.ptr(ro.y + y);
		float * inPtr = (float*) in.ptr(ri.y + y);
		inPtr += ri.x;
		outPtr += ro.x;
		
		for (int x = 0; x < ro.width; x++)
		{
			*(outPtr) = *(inPtr);
			outPtr++;
			inPtr++;
		}
	}
}

void arpWait(float s)
{
	double tre = tick();		
	while (tick() - tre  < (double)s) {}
}

void who(const Mat & m)
{
	int foo = m.type();
	
	     if (foo ==  CV_8UC1) std::cout << " 8 U C1" << std::endl;
	else if (foo == CV_16UC1) std::cout << "16 U C1" << std::endl;
	
	else if (foo ==  CV_8SC1) std::cout << " 8 S C1" << std::endl;
	else if (foo == CV_16SC1) std::cout << "16 S C1" << std::endl;
	else if (foo == CV_32SC1) std::cout << "32 S C1" << std::endl;

	else if (foo == CV_32FC1) std::cout << "32 F C1" << std::endl;
	else if (foo == CV_64FC1) std::cout << "64 F C1" << std::endl;

	else if (foo ==  CV_8UC2) std::cout << " 8 U C2" << std::endl;
	else if (foo == CV_16UC2) std::cout << "16 U C2" << std::endl;
	
	else if (foo ==  CV_8SC2) std::cout << " 8 S C2" << std::endl;
	else if (foo == CV_16SC2) std::cout << "16 S C2" << std::endl;
	else if (foo == CV_32SC2) std::cout << "32 S C2" << std::endl;

	else if (foo == CV_32FC2) std::cout << "32 F C2" << std::endl;
	else if (foo == CV_64FC2) std::cout << "64 F C2" << std::endl;

	else if (foo ==  CV_8UC3) std::cout << " 8 U C3" << std::endl;
	else if (foo == CV_16UC3) std::cout << "16 U C3" << std::endl;
	
	else if (foo ==  CV_8SC3) std::cout << " 8 S C3" << std::endl;
	else if (foo == CV_16SC3) std::cout << "16 S C3" << std::endl;
	else if (foo == CV_32SC3) std::cout << "32 S C3" << std::endl;

	else if (foo == CV_32FC3) std::cout << "32 F C3" << std::endl;
	else if (foo == CV_64FC3) std::cout << "64 F C3" << std::endl;
	
	else std::cout << "UNBEKANNTER TYP " << std::endl;
}