#include "arp_common.h"
#include "scanner.h"
#include "arpFilter.h" 
#include "arptools.h"
#include "arpVisual.h"
#include "arpserial.h"
#include "arpmap.h"
#include "arpexp.h"
#include "arpMatch.h"
#include "arp_file.h"
#include <deque>
#include <iomanip>

// TODO // globale Variablen

	bool optionSubpixel = true;
	bool optionNoise = true; //nur seitlich

	bool optionDisplay = false;
	bool optionDisplayFrames = false;
	bool optionWaitKey = false;

	bool optionScan = false;
	bool option640 = false;

	bool optionDrive = false;

	bool optionSTL = false;
	bool optionSaveImages = false;

	float brightness = 0.03;
	float rotationsheuristik = 0.80;
	
	float evasiveTurnLeft = CV_PI / 2; //+CV_PI / 4 * 3;
	float evasiveTurnRight = - evasiveTurnLeft;
	
	int startTurns = 0;
	float startTurnAngle = CV_PI / 2;
	bool optionConfirmRange = true;
	bool optionConfirmAngle = true;
	int referenceWait = 4;

	int imageCount = 230;
	float robotSaveRadius = 20.0 / cmPerUnit;
	float rotationalResolution = 2 * CV_PI / 400;
	
	float rotationCenterUnits = 13.86 / cmPerUnit;
		
	float scannerStandoff = 14.9 / cmPerUnit;
	float scannerCutoff = 300 / cmPerUnit;
	//bool optionCutoff = true;
	
	unsigned int dataOffset = 40;  //TODO!
	
	float mapScale = 1;
	float frameSize = 512;
	float mapSize = 1024;		
	
	bool optionTurn = false;
	bool optionFreeze = false;
	bool optionStraight = false;

	bool optionDespeckle = true;
	
	bool optionMatch = true;
	
	bool optionChallengeMatching = false;
	
	bool optionCalibration = false;
	
	bool optionHold = false;
	
	//TODO
	bool lastTurnWasLeftTurn = false;
	
//TODO Rückgabewert f interrupts
void driveTurn(float targetAngle, serialCom & S)
{
	// !! TODO - roboterdrehzentrum ist nicht Sensordrehzentrum - TODO !!
	if (targetAngle != 0)
	{
		while (targetAngle > 2 * CV_PI) 	// und nur hier oder bei std::winkelfunkntionen die mit grad rechnen
			targetAngle -= 2 * CV_PI;
		while (targetAngle < 0)
			targetAngle += 2 * CV_PI;
			
		if (targetAngle > CV_PI)
		{
			std::cout << "target angle orig.: " << targetAngle << std::endl; //TODO neue Variable
			targetAngle = 2 * CV_PI - targetAngle;
			targetAngle *= 180.f / CV_PI;
			
			if (optionConfirmAngle)
			{
				std::cout << "please confirm direction change: right " << targetAngle << " (any key)" << std::endl;
				std::cin.sync();
				std::cin.get();
			}
			else
				std::cout << "asking for direction change: right " << targetAngle << std::endl;
				
			S.sendSimple(CMD_right_degrees);
			S.sendSimple(((unsigned int) targetAngle * rotationsheuristik) + dataOffset);
			lastTurnWasLeftTurn = false;
			
			unsigned char returnmsg = 0;
			while (returnmsg != MSG_movement_complete)
			{
				returnmsg = S.receive();
			}
			
		}
		else //targetAngle
		{
			std::cout << "target angle orig.: " << targetAngle << std::endl;
			targetAngle *= 180.f / CV_PI;

			if (optionConfirmAngle)
			{
				std::cout << "please confirm direction change: left " << targetAngle << " (any key)" << std::endl;
				std::cin.sync();
				std::cin.get();
			}
			else
				std::cout << "asking for direction change: left " << targetAngle << std::endl;
				
			S.sendSimple(CMD_left_degrees);
			lastTurnWasLeftTurn = true;
			S.sendSimple(((unsigned int) targetAngle * rotationsheuristik) + dataOffset);

			unsigned char returnmsg = 0;
			while (returnmsg != MSG_movement_complete)
			{
				returnmsg = S.receive();				
			}
		}
	}
}

//TODO rückgabewert f. interrupts usw
void driveStraight(float targetRange, serialCom & S)
{
	if (targetRange != 0)
	{
		float targetRangeCM = targetRange * cmPerUnit;
		if (optionConfirmRange)
		{
			std::cout << "please confirm forward movement (cm): " << targetRangeCM << " (any key)" << std::endl;
			std::cin.sync();
			std::cin.get();
		}
		else
			std::cout << "asking for forward movement (cm): " << targetRangeCM << std::endl;
		
		unsigned int targetRangeCMint;
		if (targetRangeCM > 0)
			targetRangeCMint = targetRangeCM + 0.5; //wg. truncation
		else
		{
			std::cerr << "driving backwards is not permitted" << std::endl;
			targetRangeCMint = 0;
		}
		
		if (targetRangeCMint != 0)	
		{
			S.sendSimple(CMD_forward_cm);
			S.sendSimple(((unsigned int) targetRangeCM) + dataOffset);
			
			unsigned char returnmsg = 0;					
			while (returnmsg != MSG_movement_complete)
			{
				returnmsg = S.receive();
			}
		}
	}
}
					
void addNoise(Mat & cut)  //TODO! z,x getrennt!! !
{
	float* p = (float*) cut.data;
	//p += 2; //Z!
	
	Mat foo(1,2,CV_32FC1);
	float * fooPtr = (float*) foo.data;
	float sinus = 2 * sin(CV_PI / 400); //sin(0.5 * CV_PI / 200) * 2 *
	for(int r = 0; r < cut.rows - 1; r++)
	{
		float radius = sinus * p[2];
		randu(foo, -radius,  radius);
		p[0] += fooPtr[0];  		//lateral
		//p[1] +=  fooPtr[0] * 20;  //altitude
		
		if(p[2] > 111)			
			p[2] +=  4 * fooPtr[1];  		//range ////////TODO
		else if(p[2] > 60)
			p[2] += fooPtr[1];
		///TODO
		
		p += 3;
	}
}

void lookup(const Mat & input, const Mat & LUT, Mat & output)
{

	assert(input.rows == 1);
	assert(input.type() == CV_32FC1);
	assert(output.cols == 3);
	assert(input.cols == output.rows);
	assert(output.type() == CV_32FC1);
	
	output = Scalar::all(0);
	
	float* ptin = (float*) input.data;
	float vorkomma;
	float nachkomma;
	
	if (optionSubpixel)
	{
		for(int r = 0; r < input.cols - 1; r++)
		{
			nachkomma = std::modf(*(ptin), &vorkomma);	
			ptin++;
						
			float* ptout = (float*) output.ptr(r);
			float* ptLUT = (float*) LUT.ptr(r);
			ptLUT += 3 * (LUT.cols - 1 - (unsigned int)vorkomma );
			float* ptLUT2 = ptLUT;
			ptLUT2 -= 3;
			
			//interpolate
			* (ptout) = *(ptLUT);// + (1.f-nachkomma) * (*(ptLUT2) - *(ptLUT))	; 	//X   
					//versatz aus der Laserebene heraus bedingt durch abs. Or. zw. Kamera u. Roboter-KS -> kann für SP vern. w.
			ptout++;
			ptLUT2++;
			ptLUT++;
			* (ptout) = *(ptLUT) +  nachkomma * (*(ptLUT2) - *(ptLUT))	; 	//Y
			ptout++;
			ptLUT2++;
			ptLUT++;
			* ptout     = 0 - (*(ptLUT) + nachkomma * (*(ptLUT2  ) - *(ptLUT  ))) ;	//Z

		} //rows
	}
	else //if not optionSubpixel
	{
		for(int r = 0; r < input.cols - 1; r++)
		{
			float* ptout = (float*) output.ptr(r);
			float* ptLUT = (float*) LUT.ptr(r);
			ptLUT += 3 * (LUT.cols - 1 - (int)*(ptin++));

			* (ptout) = *(ptLUT); 		
			ptout++;
			ptLUT++;
			* (ptout) = *(ptLUT); 	
			ptout++;
			ptLUT++;
			* ptout     = 0 - *(ptLUT);
			//ptLUT++;
		}
	}
	
} //lookup()


void sweepStepControlled(vector <Mat> & images, int imageCount, serialCom & S, VideoCapture & capture)
{
	for(int i = 0; i < imageCount; i++)
		if (images[i].type() == 123)  //runtime error if n/e    TODO ? TODO TODO
		{
			std::cerr << "images must be initialized before scanning, nr " << i << std::endl;
			exit(EXIT_FAILURE);
		}
		
	S.sendSimple(CMD_reference);
	arpWait(referenceWait);	
		
	S.sendSimple(CMD_laser_on);
	
	double longtimer = tick();
	for(int counter = 0; counter < imageCount; counter++)
	{
		Mat frame;
		while (! capture.grab()){/*NOP*/};
		while (!capture.retrieve(frame)){/*NOP*/};
		frame.copyTo(images[counter]);

		S.sendSimple(CMD_step_right);
		
		waitKey(5); // serial communication grace 
	}
	std::cerr << "longtimer: " << tick() - longtimer <<std::endl;
	S.sendSimple(CMD_all_stop);		
}

void hold(serialCom & S)
{
	S.sendSimple(CMD_reference);
	arpWait(referenceWait);	
	
	for (int offset = 0; offset < 115; offset++)
	{
		S.sendSimple(CMD_step_right);
		arpWait(0.05); 
	}
	std::cerr << "press any key" << std::endl;
	std::cin.sync();
	std::cin.get();
	std::cerr << "press any key" << std::endl;
	std::cin.sync();
	std::cin.get();
}

void takeCalibrationImages(serialCom & S, VideoCapture & capture, const std::stringstream & dir, int sweep = 50)
{
	S.sendSimple(CMD_reference);
	arpWait(referenceWait);	
	
	for (int offset = 0; offset < imageCount / 2 - sweep / 2; offset++)
	{
		S.sendSimple(CMD_step_right);
		arpWait(0.05); 
	}
	
	float calibWait = 0.25;
	int cc = 0;
	while (cc < 500) //wg. begrenztem Platz auf A110. Zielpfad wäre sinnvoll
	{
		for(int i = 0; i < sweep; i++)
		{
			arpWait(calibWait);
			Mat image1;
			Mat frame1;
			while (! capture.grab()){/*NOP*/};
			while (!capture.retrieve(frame1)){/*NOP*/};
			frame1.copyTo(image1);

			std::stringstream s1;
			s1 << dir.str();
			assertSlash(s1);
			s1 << std::setfill('0') << std::setw(2) << cc << "a.png";

			if (!imwrite(s1.str(), image1))
				std::cerr << "Attention: could not write " << s1.str() << std::endl;

			S.sendSimple(CMD_laser_on);
			
			arpWait(calibWait);
			Mat image2;
			Mat frame2;
			while (! capture.grab()){/*NOP*/};
			while (!capture.retrieve(frame2)){/*NOP*/};
			frame2.copyTo(image2);
			
			std::stringstream s2;
			s2 << dir.str();
			assertSlash(s2);
			s2 << std::setfill('0') << std::setw(2) << cc << "b.png";
			cc++;
			if (!imwrite(s2.str(), image2))
				std::cerr << "Attention: could not write " << s2.str() << std::endl;
			
			S.sendSimple(CMD_laser_off);
			arpWait(0.1);
			S.sendSimple(CMD_step_right);
			
		}
		
		for(int i = 0; i < sweep; i++)
		{
			arpWait(calibWait);
			Mat image3;
			Mat frame3;
			while (! capture.grab()){/*NOP*/};
			while (!capture.retrieve(frame3)){/*NOP*/};
			frame3.copyTo(image3);
			
			std::stringstream s1;
			s1 << dir.str();
			assertSlash(s1);
			s1 << std::setfill('0') << std::setw(2) << cc << "a.png";
	
			if (!imwrite(s1.str(), image3))
				std::cerr << "Attention: could not write " << s1.str() << std::endl;			
			S.sendSimple(CMD_laser_on);
			
			arpWait(calibWait);
			Mat image4;
			Mat frame4;
			while (! capture.grab()){/*NOP*/};
			while (!capture.retrieve(frame4)){/*NOP*/};
			frame4.copyTo(image4);
			
			std::stringstream s2;
			s2 << dir.str();
			assertSlash(s2);
			s2 << std::setfill('0') << std::setw(2) << cc << "b.png";
			cc++;
			if (!imwrite(s2.str(), image4))
				std::cerr << "Attention: could not write " << s2.str() << std::endl;

			S.sendSimple(CMD_laser_off);
				arpWait(0.1);
			S.sendSimple(CMD_step_left);
		}		

	
	} //while cc < 1000
	
	arpWait(0.1);
	S.sendSimple(CMD_all_stop);		
	
}


void deSpeckle (const vector <Mat> & in, vector <Mat> & out)
{
	//TODO
	out[0] = in[0];
	out[in.size()-1] = in[in.size()-1];
	
	for(unsigned int m = 1; m < in.size() -1; m++)
	{

		float * p0 = (float*) in[m-1].data;
		float * p1 = (float*) in[m].data;
		float * p2 = (float*) in[m+1].data;
		float * o = (float*) out[m].data;
			
		for (int r = 0; r < in[m].cols; r++)
		{
			if ((abs((int)*p0 - (int)*p1) <= 2)||(abs((int)*p1 - (int)*p2) <= 2))
				*o = *p1;
			else
				*o = 0;
				
			p0++;
			p1++;
			p2++;
			o++;
		}
	}
}

// nimmt man für das Koordinatensystem die openCV-Konvention an ("Ursprung links oben"),
// ist die Richtung 0, also Geradeaufahrt nach Systemstart, "oben", und Geradeausfahrt bedeutet y' = y - Distanz.
void to3D (vector <Mat> & data, const float angle) 
{
	float a = 1.5 * CV_PI - data.size() * angle / 2; //Winkelzentrierung n. Bilderzahl und Schrittwinkel
	for(unsigned int m = 0; m < data.size(); m++)
	{
		for (int r = 0; r < data[m].rows; r++)
		{
			float * p = (float*) data[m].ptr(r);
			float p0 = p[0];
			p[0] = p[2] * sin(a) - p[0] * cos(a);	//sin/cos LUT wäre möglich
			p[2] = p0 * sin(a) + p[2] * cos(a);
		}
		a += angle;
	}
}

void cutoff(vector <Mat> & data, const float maxRange, const float minRange = 0) 
{
	for(unsigned int m = 0; m < data.size(); m++)
	{
		for (int r = 0; r < data[m].rows; r++)
		{
			float * p = (float*) data[m].ptr(r);
			if ((p[2] > maxRange) || (p[2] < minRange))
			{
				p[0] = p[1] = p[2] = 0;
			}
		}
	}	
}

void representationsOfFrame(worldData & worldFrame /*, const Pose & position, const float scannerStandoff*/)
{					
	threshold(worldFrame.floor, worldFrame.floor, 1, 1, THRESH_BINARY);
	relaxFloorGrid(worldFrame.floor);		//TODO zu
	shrinkFloorGrid(worldFrame.floor, /*position,*/ scannerStandoff);

	normalize(worldFrame.wall, worldFrame.wall, 31., 0.);  //TODO! das ist Kosmetik
	buildRayGrid(worldFrame.wall, worldFrame.space);
}				


//TODO map soll hier const sein, dann muss aber das erodieren des floor grids anders stattfinden
void representationsOfMap(worldData & map, Mat & shortRangeTarget, Mat & longRangeTarget, vector <Mat> & visuals)
{
	//Point target;
	
	Mat ray = map.space.clone();
	
	Mat tempray;
	Mat nullMat; 
	Mat foo = ray.clone();
	
	erode(ray, tempray, nullMat, Point(-1,-1), 3);
	
	dilate(tempray, ray, nullMat, Point(-1,-1), 3);
	
	if (optionDisplay)
	{
		imshow("original ray", foo);
		imshow("eroded ray", tempray);
		imshow("dilated ray", ray);
	}
	
	Mat dilatedWall(ray.size(), ray.type());
	
	dilate(map.wall, dilatedWall, nullMat, Point(-1,-1), 3);
		
	dilatedWall.convertTo(dilatedWall, CV_8UC1, 256);
	
	Mat rayFringe(ray.size(), ray.type());
	ray.convertTo(rayFringe, CV_8UC1, 256);
	Canny(rayFringe, rayFringe, 0, 1);
	
	threshold(dilatedWall, dilatedWall, 1, 255, THRESH_BINARY);
	Mat interest(ray.size(), ray.type());
	
	interest = rayFringe & ~dilatedWall;

	if (optionDisplay)
	{
		imshow("fringe", rayFringe);
		imshow("interest", interest);
	}

	Mat hough8U(interest.size(), CV_8UC1);
	interest.convertTo(hough8U, 8U);
	vector < Vec <int, 4> > hlines;
	HoughLinesP(hough8U, hlines, 1, CV_PI / 180, 20, 20, 10); //TODO cart res, ang res, grid thresh, length thresh, gap allow
	Mat hough(hough8U.size(), interest.type());
	drawHough(hlines, hough);
	vector < Vec <int, 5> > hlinesDist;
	for (int i = 0; i < hlines.size(); i++)
	{
		Vec <int,5> v;
		v[0] = hlines[i][0];
		v[1] = hlines[i][1];
		v[2] = hlines[i][2];
		v[3] = hlines[i][3];
		
		v[4] = (int) sqrt((v[0] - v[2])*(v[0] - v[2]) + (v[1] - v[3])*(v[1] - v[3]));	

		hlinesDist.push_back(v);
	}
	
	float baseInterest = 0.005; //das interstgrid wird >0 initialisiert, damit der pfadfinder innehralb des verkl
								//frame.floor alle pkt. als kandidaten betrachtet.	
								
	std::sort(hlinesDist.begin(), hlinesDist.end(),  houghGreater); 
	Mat interestArea(ray.size(), ray.type(), Scalar::all(1 * baseInterest)); //ATTN != interest
	for (signed int v = hlinesDist.size() - 1; v >= 0; v--)
	{
		//int aspect = 1;
		
		Point p[4];
		int p0x = hlinesDist[v][0];
		int p0y = hlinesDist[v][1];
		int p1x = hlinesDist[v][2];
		int p1y = hlinesDist[v][3];

		p[0].x = p0x;
		p[0].y = p0y;
		p[1].x = (p0x + p1x) / 2 + (p0y - p1y) /2;//* aspect;
		p[1].y = (p0y + p1y) / 2 - (p0x - p1x) /2;//* aspect;
		p[2].x = p1x;
		p[2].y = p1y;
		p[3].x = (p0x + p1x) / 2 - (p0y - p1y) /2;//* aspect;
		p[3].y = (p0y + p1y) / 2 + (p0x - p1x) /2;//* aspect;
		
		int ra = hlinesDist[v][4];
		fillConvexPoly(interestArea, p, 4, Scalar::all(ra * baseInterest)); // TODO!
	}
	
	min(map.floor, interestArea, shortRangeTarget);
	
	min(ray, interestArea, longRangeTarget);
	
	
	// passing visuals of intermediate steps
		Mat saveWall;
		vector <Mat> saveWallVector;
		for (int i = 0; i < 3; i++)
		{
			Mat temp (ray.size(), CV_32SC1);
			saveWallVector.push_back(temp);
		}
		
		Mat displaywall;
		displaywall = map.wall.clone();
		normalize(displaywall, displaywall, 31., 0.);  //TODO! das ist Kosmetik
		
		Mat displayfloor;
		displayfloor = map.floor.clone();
		normalize(displayfloor, displayfloor, 31., 0.);  

		displayfloor.convertTo(saveWallVector[0], CV_32SC1, 256);
		displaywall.convertTo(saveWallVector[1], CV_32SC1, 256);
		hough.convertTo(saveWallVector[2], CV_32SC1, 256);	
		merge(saveWallVector, saveWall);


		Mat saveFloor; 
		vector <Mat> saveFloorVector;
		for (int i = 0; i < 3; i++)
		{
			Mat temp(ray.size(), CV_32SC1);
			saveFloorVector.push_back(temp);
		}

		displaywall.convertTo(saveFloorVector[0], CV_32SC1, 256);
		interestArea.convertTo(saveFloorVector[1], CV_32SC1, 256);
		interest.convertTo(saveFloorVector[2], CV_32SC1, 256);		
		merge(saveFloorVector, saveFloor);
		
		saveWall *= 256;
		saveFloor *= 256;
		visuals.push_back(saveWall.clone());
		visuals.push_back(saveFloor.clone());
	//
	
} //representationsOfMap

int initImaging(serialCom & S, Size &imageSize, VideoCapture & capture, vector <Mat> & images)
{
	S.init();
	for (int i = 0; i < imageCount; i++)  //TODO - ist das notwendig?
	{
		Mat m(imageSize, CV_8UC1);
		images.push_back(m);
	}

	capture.open(-1);
	if( !capture.isOpened() )
	{
		fprintf( stderr, "Could not initialize video capture\n" );
		return(EXIT_FAILURE);
	}

	capture.set(CV_CAP_PROP_BRIGHTNESS, brightness);
	
	capture.set(CV_CAP_PROP_FRAME_WIDTH, imageSize.width);
	capture.set(CV_CAP_PROP_FRAME_HEIGHT, imageSize.height);
	return (EXIT_SUCCESS);
}


	bool houghGreater (cv::Vec<int, 5 >   i, cv::Vec<int, 5 >   j) 
	{
		return (i[4] > j[4]); 
	}
	bool houghSmaller (cv::Vec<int, 5 >   i, cv::Vec<int, 5 >   j) 
	{ 
		return (i[4] < j[4]); 
	}

int main(int argc, char **argv)
{
	//INIT

		std::stringstream fileset;
		
		for(int i = 1; i < argc; i++)
		{
			if 		(strcmp(argv[i], "scan") == 0) 			optionScan = true;
			else if (strcmp(argv[i], "drive") == 0)			optionDrive = true;
			else if (strcmp(argv[i], "display") == 0)		optionDisplay = true;
			else if (strcmp(argv[i], "frames") == 0)		optionDisplayFrames = true;
			else if (strcmp(argv[i], "stl") == 0)			optionSTL = true;
			else if (strcmp(argv[i], "png") == 0)			optionSaveImages = true;
			else if (strcmp(argv[i], "320") == 0)			option640 = false;
			else if (strcmp(argv[i], "640") == 0)			option640 = true;
			else if (strcmp(argv[i], "nosubpixel") == 0)	optionSubpixel = false;
			else if (strcmp(argv[i], "waitkey") == 0)		optionWaitKey = true;
			else if (strcmp(argv[i], "count") == 0)			{i++; 
																int req = atoi(argv[i]);
																if (req <= imageCount)
																	imageCount = req;
																else
																{
																	std::cerr << "maximum imageCount is " << imageCount
																			  << ". Proceeding." << std::endl;
																}																
															}		
			else if (strcmp(argv[i], "nonoise") == 0)		optionNoise = false;
			else if (strcmp(argv[i], "startturns") == 0)	{i++; startTurns = atoi(argv[i]);}
	/**/	else if (strcmp(argv[i], "brightness") == 0)	{i++; brightness = atof(argv[i]);}
			else if (strcmp(argv[i], "rotation") == 0)		{i++; rotationsheuristik = (float) atof(argv[i]);}
			else if (strcmp(argv[i], "fileset")	== 0)		{i++; fileset << argv[i];}			
			else if (strcmp(argv[i], "turn") == 0)			optionTurn = true;
			else if (strcmp(argv[i], "freeze") == 0)		optionFreeze = true;
			else if (strcmp(argv[i], "straight") == 0)		optionStraight = true;	
			else if (strcmp(argv[i], "nodespeckle") == 0)	optionDespeckle = false;
			else if (strcmp(argv[i], "nomatch") == 0)		optionMatch = false;
	/**/	else if (strcmp(argv[i], "challenge") == 0)		optionChallengeMatching = true;			
			else if (strcmp(argv[i], "cutoff") == 0)		{i++; scannerCutoff = atoi(argv[i]);}
			else if (strcmp(argv[i], "calibration") == 0)	{	optionCalibration= true; optionScan = true;}
			else if (strcmp(argv[i], "hold") == 0)			{	optionHold = true;}

			else {std::cerr << "unknown option: \"" << argv[i] << "\"" << std::endl; return(EXIT_FAILURE); }
		}
		
		if ((fileset.str() != "") && (optionScan))
		{
			optionScan = false;
			std::cerr << "naming a fileset overrides scan option" << std::endl;
		}
		if ((fileset.str() != "") && (optionDrive))
		{
			optionDrive = false;
			std::cerr << "naming a fileset overrides drive option" << std::endl;
		}
		if ((fileset.str() == "") && (! optionScan ))
		{
			std::cerr << "please name an image directory or connect ARP and choose \"scan\" option" << std::endl;
			exit(EXIT_FAILURE);
		}

		std::cerr << "option optionScan: " << optionScan << std::endl;
		std::cerr << "option optionDrive: " << optionDrive << std::endl;
		std::cerr << "option display: " << optionDisplay << std::endl;
		std::cerr << "option STL: " << optionSTL << std::endl;
		std::cerr << "option saveImages: " << optionSaveImages << std::endl;
		std::cerr << "option 640: " << option640 << std::endl;
		std::cerr << "option subpixel: " << optionSubpixel << std::endl;
		std::cerr << "option waitKey: " << optionWaitKey << std::endl;
		std::cerr << "imageCount: " << imageCount << std::endl;
		std::cerr << "optionNoise: " << optionNoise << std::endl;
		std::cerr << "brightness: " << brightness << std::endl;
		std::cerr << "rotation: " << rotationsheuristik << std::endl;
		std::cerr << "optionStraight: " << optionStraight << std::endl;
		std::cerr << "optionTurn: " << optionTurn << std::endl;
		std::cerr << "optionFreeze: " << optionFreeze << std::endl;
		std::cerr << "optionDespeckle: " << optionDespeckle << std::endl;
			
		vector<Mat> images;
		Size imageSize(320, 240);  //standard
		if (option640)
		{
			imageSize.width *= 2;
			imageSize.height *= 2;
		}
		Mat LUT;
		if (option640)
			LUT = loadCalibrationData("LUT640.xml", "LUT640");
		else
			LUT = loadCalibrationData("LUT320.xml", "LUT320");
			
		
		serialCom S;			//TODO static sinnvoll?
		VideoCapture capture;	//TODO static sinnvoll?
		

			
		if (optionScan)
		{
			if (EXIT_SUCCESS != initImaging(S, imageSize, capture, images))
			{
				std::cerr << "could not initialize imaging" << std::endl;
				return(EXIT_FAILURE);
			}
		}
		else
		{
			std::cout << "loading fileset " << fileset.str() << " ... " << std::endl;
			loadFileset(fileset, images, imageCount, option640);
			std::cout << "." << std::endl;
		}
		
		if  (optionScan)
			S.sendSimple(CMD_all_stop);	
			
		std::stringstream baseLogDir;
		baseLogDir << "logARP_" << timeString();
		assertSlash(baseLogDir);
		//if (optionScan || optionSTL)
		{
			if (mkdir(baseLogDir.str().c_str(), 0777)) 	//false bei erfolg!
			{
				std::cerr << "could not create log directory" << std::endl; 
				exit(EXIT_FAILURE);
			}
		}
		
		if (optionCalibration)
		{
			capture.set(CV_CAP_PROP_BRIGHTNESS, 0.2);
			capture.set(CV_CAP_PROP_FRAME_WIDTH, 640);
			capture.set(CV_CAP_PROP_FRAME_HEIGHT, 480);
			 takeCalibrationImages(S, capture, baseLogDir);
			 // max. n images
			 std::cout << "end program" << std::endl;
			 exit(EXIT_SUCCESS);
		}
			
		if (optionHold)
			hold(S);
	
		worldData worldMap(Size(mapSize * mapScale, mapSize * mapScale)); //TODO: static sinnvoll?
		worldData worldFrame(Size(mapScale * frameSize, mapScale * frameSize));
		Mat shortRangeTarget(worldMap.size(), worldMap.floor.type());
		Mat longRangeTarget(worldMap.size(), worldMap.floor.type());	

		Pose position_soll; 
		Pose position_ist; 
		position_soll.x = position_ist.x = 0;
		position_soll.y = position_ist.y = 0;
		position_soll.r = position_ist.r = 0;
	
	//Hauptschleife, main loop
	position_ist.print("position_ist");

	for (int cycleCount = 0; true; cycleCount++)
	{
		std::stringstream logSubDir;
		//if (optionScan || optionSTL)
			createLogDir(baseLogDir, cycleCount, logSubDir);
		
		std::cout << std::endl << "CYCLE " << cycleCount << "###########" << std::endl;
		position_ist.print("position_ist");
		position_soll.print("position_soll");
		
		// SCAN
			
			vector <Mat> visuals;
			if (optionScan)
			{
				sweepStepControlled(images, imageCount, S, capture);
			}
			
			int imageCount = images.size();
			vector <Mat> world3D;
			world3D.reserve(imageCount);

			vector <Mat> maxed;
			maxed.reserve(imageCount);
			vector <Mat> despeckled;
			despeckled.reserve(imageCount);
					
			for (int j = 0; j < imageCount; j++)
			{
				Mat f(Size(images[0].cols, 1), CV_32FC1); 
				despeckled.push_back(f);
				maxed.push_back(f);
			}

			for (int j = 0; j < imageCount; j++)
			{
				std::cerr << ".";
				if (optionDespeckle)
					arpFilter12(images[j], maxed[j], option640);
				else 
					arpFilter12(images[j], despeckled[j], option640);
			}
			
			if (optionDespeckle)
				deSpeckle(maxed, despeckled);

			for (int j = 0; j < imageCount; j++)
			{
				Mat worldCut(Size(3, maxed[0].cols), CV_32FC1);
				lookup(maxed[j], LUT, worldCut);
				if (optionNoise)
					addNoise(worldCut);
				world3D.push_back(worldCut);
				if (optionDisplayFrames)
					showCut(worldCut, images[j], despeckled[j]);
			}
			std::cerr << std::endl;
			//if (optionCutoff)
			cutoff(world3D, scannerCutoff);
			to3D(world3D, rotationalResolution);
		
		// neues Karten-"Frame" aus Scan
		
			worldFrame.floor = Scalar::all(0);
			worldFrame.wall = Scalar::all(0);
			worldFrame.space = Scalar::all(0);
			occCheck(world3D, worldFrame.floor, worldFrame.wall, mapScale);
			
			///////////////TODO//////////////////////
			//Mat nullmat;
			//blur(worldFrame.wall,worldFrame.wall,Size(3,3),Point(-1,-1));
			//erode(worldFrame.wall,worldFrame.wall, nullmat);
			//worldFrame.wall *= 2;
			/////////////////////////////////////////
			
			representationsOfFrame(worldFrame /*, position_ist, scannerStandoff*/ );	
		
		// GROUND TRUTH KORREKTUR
			Pose targetXYoldR;				// vorgezogen f. logausgabe
			Pose targetRotationCenter;	
			if (cycleCount > 0)
			{
				// bestimme Drehzentrum aus unkorrigierter Vorausbewegung bei alter Rotation
					
					
					targetXYoldR.x = position_soll.x;
					targetXYoldR.y = position_soll.y;
					targetXYoldR.r = position_ist.r;
					targetXYoldR.print("targetXYoldR (pos.-soll ohne Drehung)");
					
					targetRotationCenter = getRotationCenter(targetXYoldR, rotationCenterUnits);
					targetRotationCenter.r = position_soll.r;
					targetRotationCenter.print("daraus drehzentrum, eingabe f. radialMatching");
					
				// bestimme tatsächliche Drehung. Parameter: 
				//		* x,y des absoluten Drehzentrum; 
				//		* rotation des absoluten Zielwinkels (für Einschränkung des Suchraums)
					float shift = radialMatching(worldFrame.wall, worldMap.wall, position_ist, 
										targetRotationCenter, visuals, rotationCenterUnits, optionChallengeMatching); //absolut z. Karte
					std::cout << "gematchte Rotation "  << shift << " bei Zielrotation " << position_soll.r << std::endl; 
				
				//position_soll.r = shift;
 					if (optionMatch)
						position_ist = rotate(targetRotationCenter, shift, position_soll, rotationCenterUnits);
					else
						position_ist = rotate(targetRotationCenter, position_soll.r, position_soll, rotationCenterUnits);
					position_ist.print("Position - ist, Eingabe für Kartenupdate :");

			}
		
		// Kartenupdate

			worldMap.update(worldFrame, position_ist);
			representationsOfMap(worldMap, shortRangeTarget, longRangeTarget, visuals);

		// NEW TARGET
			
			if (optionFreeze)
			{
				position_soll.x = position_ist.x;
				position_soll.y = position_ist.y;
				position_soll.r = position_ist.r;
			}
			else if (optionStraight)
			{
				position_soll.y = position_ist.y - 5;
				position_soll.x = position_ist.x;
				position_soll.r = position_ist.r;
			}
			else if (optionTurn)
			{
				position_soll.y = position_ist.y;
				position_soll.x = position_ist.x;
				position_soll.r = position_ist.r - CV_PI / 2;
			}
			else if (startTurns > 0)
			{		
				startTurns --;
				position_soll.x = position_ist.x;
				position_soll.y = position_ist.y;
				position_soll.r = position_ist.r - startTurnAngle;
			}
			else
			{
				if (lastTurnWasLeftTurn)
					bestTargetPose(shortRangeTarget, longRangeTarget, position_ist, position_soll, evasiveTurnLeft);
				else
					bestTargetPose(shortRangeTarget, longRangeTarget, position_ist, position_soll, evasiveTurnRight);
			}
			position_soll.print("neue soll-Position");
				
		// VISUALS
		
			//drawPositionCircles(visuals[4], position, position_soll);
			//drawPositionCircles(visuals[5], position, position_soll);

			visuals.push_back(worldFrame.wall.clone());
			visuals.push_back(worldFrame.floor.clone());

			////////////// unfortunately, imwrite doesn't work like imshow here ////////////////
				if (optionDisplay)
				{
					show(visuals);
					waitKey();
				}
					
			if (optionSTL)
			{
				std::cerr << "writing STL... ";
				writeSTL(world3D, logSubDir.str());
				std::cerr << "OK" << std::endl;
			}		

			if (optionSaveImages)
			{
				std::cout << "saving camera images" << std::endl;
				saveCameraImages(images, logSubDir.str());
			}					
						
				for (unsigned int i = 0; i < visuals.size(); i++) //TODO: böser Hack.
				{
					if (visuals[i].cols == mapSize)
						visuals[i] /= 256;
					else
						visuals[i] *= 256;
				}					
				saveVisuals(visuals, "webroot");
				saveVisuals(visuals, logSubDir.str());
			
		// Logdatei
		
			string logPath = logSubDir.str();
			assertSlash(logPath);
			logPath.append("log.txt");
			std::ofstream log(logPath.c_str());
			if (!log){std::cerr<<"could not open log for writing: " << logPath << std::endl; exit(EXIT_FAILURE);}
			log << std::setfill('0') << std::setw(4) << cycleCount << ";position;"
				<< std::fixed
				<< std::setw(6) << position_ist.x << ";" 
				<< std::setw(6) << position_ist.y << ";" 
				<< std::setw(6) << position_ist.r << ";target;"
				<< std::setw(6) << position_soll.x << ";" 
				<< std::setw(6) << position_soll.y << ";" 
				<< std::setw(6) << position_soll.r << ";geradeaus;" 
				//<< std::setw(6) << newXYoldR.x << ";" 
				//<< std::setw(6) << newXYoldR.y << ";" 
				//<< std::setw(6) << newXYoldR.r << ";rotc;" 
				<< std::setw(6) << targetRotationCenter.x << ";" 
				<< std::setw(6) << targetRotationCenter.y << ";" 
				<< std::setw(6) << targetRotationCenter.r << "; ;" 
				
				<< std::endl;
			log.close();
		
		// DRIVE
		
			float targetAngle = position_soll.r - position_ist.r;
			float targetRange = sqrt((position_soll.x - position_ist.x) * (position_soll.x - position_ist.x) +
				(position_soll.y - position_ist.y) * (position_soll.y - position_ist.y));	
				
			std::cout << "angle " << targetAngle << ", range: " << targetRange << std::endl;
			
			if (!optionDrive)
			{
				std::cout << "end program" << std::endl;
				exit(EXIT_SUCCESS);
			}
			else
			{
				driveStraight(targetRange, S);
				driveTurn(targetAngle, S);
			} 
			
		// END DRIVE		
		
	} //for cycleCount
		
	//loop if drive
	if (optionDisplay)
	{
		waitKey();
	}
}